/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.api;

import iaik.apps.trustmanager.RevocationStatus;
import iaik.apps.trustmanager.TransientTmException;
import iaik.apps.trustmanager.TrustedKeyUsage;
import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.TrustmanagerPolicyException;
import iaik.apps.trustmanager.ValidityStatus;
import iaik.apps.trustmanager.api.InitTrustmanager;
import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.cert.CertStore;
import iaik.apps.trustmanager.crl.CRLDistributionPoint;
import iaik.apps.trustmanager.crl.CRLManager;
import iaik.apps.trustmanager.ldap.LocalLDAP;
import iaik.apps.trustmanager.time.TrustedTime;
import iaik.apps.trustmanager.trust.PurposeProperties;
import iaik.apps.trustmanager.trust.RevocationInfo;
import iaik.apps.trustmanager.trust.TrustProperties;
import iaik.apps.trustmanager.trust.TrustRecord;
import iaik.apps.trustmanager.trust.TrustStore;
import iaik.apps.trustmanager.utils.Integrity;
import iaik.apps.trustmanager.utils.SwingWorker;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.apps.trustmanager.utils.X500Utils;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.security.provider.IAIK;
import iaik.utils.InternalErrorException;
import iaik.x509.RevokedCertificate;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Trustmanager {
    private static final boolean DEBUG = false;
    private static boolean modified_CertStore = true;
    private static boolean modified_TrustEnv = true;
    private static boolean modified_TrustStore = true;
    private static boolean modified_CRLManager = true;
    private static String iOErrorMessage = null;
    private static String tMErrorMessage = null;

    public static void makeEmptyFiles(String dir, char[] pwd) {
        try {
            Security.insertProviderAt((Provider)new IAIK(), 1);
            Integrity.setPassword("iaikSmime".toCharArray());
            TrustEnv.initialize("C:/Development/Trustmanager/trust/trust.sys");
            CertStore certStore = new CertStore();
            TrustStore trustStore = new TrustStore();
            CRLManager cRLManager = new CRLManager();
            TrustEnv.store();
            CertStore.store();
            TrustStore.store();
            CRLManager.save();
            System.exit(1);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }

    public static boolean isModified() {
        return modified_CertStore | modified_TrustEnv | modified_TrustStore | modified_CRLManager;
    }

    public static void load(String filename, char[] password) throws TrustmanagerException, IOException, TrustmanagerPolicyException {
        InitTrustmanager initTask = new InitTrustmanager(filename, password);
        initTask.go();
        while (!initTask.done()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e2) {
                throw new InternalErrorException(e2.getMessage());
            }
        }
        modified_CertStore = false;
        modified_TrustEnv = false;
        modified_TrustStore = false;
        modified_CRLManager = false;
    }

    public static synchronized void loadCertStore() throws IOException {
        CertStore.load();
        modified_CertStore = false;
    }

    public static synchronized void loadTrustEnv() throws TrustmanagerException, IOException {
        TrustEnv.load(TrustEnv.envFile);
        modified_TrustEnv = false;
    }

    public static synchronized void loadTrustStore() throws TrustmanagerException, IOException {
        TrustStore.load();
        modified_TrustStore = false;
    }

    public static synchronized void initCRLManager() throws IOException {
        CRLManager.init();
        modified_CRLManager = false;
    }

    public static void changePassword(char[] oldPwd, char[] newPwd) throws IOException, TrustmanagerPolicyException, TrustmanagerException {
        Integrity.changePassword(oldPwd, newPwd);
        Trustmanager.store();
    }

    public static String getHomeDirectory() {
        return TrustEnv.getHomeDirectory();
    }

    public static void store() throws IOException {
        TrustEnv.store();
        modified_TrustEnv = false;
        TrustStore.store();
        modified_TrustStore = false;
        CertStore.store();
        modified_CertStore = false;
        CRLManager.save();
        modified_CRLManager = false;
    }

    public static void load_if_necessary() throws TrustmanagerException, IOException {
        iOErrorMessage = null;
        tMErrorMessage = null;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                try {
                    if (modified_TrustEnv) {
                        TrustEnv.load(TrustEnv.envFile);
                        modified_TrustEnv = false;
                    }
                    if (modified_TrustStore) {
                        TrustStore.load();
                        modified_TrustStore = false;
                    }
                    if (modified_CertStore) {
                        CertStore.load();
                        modified_CertStore = false;
                    }
                    if (modified_CRLManager) {
                        CRLManager.init();
                        modified_CRLManager = false;
                    }
                }
                catch (IOException e2) {
                    iOErrorMessage = e2.getMessage();
                }
                catch (TrustmanagerException e3) {
                    tMErrorMessage = e3.getMessage();
                }
                return null;
            }
        };
        if (iOErrorMessage != null) {
            throw new IOException(iOErrorMessage);
        }
        if (tMErrorMessage != null) {
            throw new TrustmanagerException(tMErrorMessage);
        }
    }

    public static void store_if_necessary() {
        iOErrorMessage = null;
        if (modified_TrustEnv) {
            try {
                TrustEnv.store();
                modified_TrustEnv = false;
            }
            catch (IOException e2) {
                iOErrorMessage = "Cannot write TrustEnv to disk. ";
            }
        }
        if (modified_TrustStore) {
            try {
                TrustStore.store();
                modified_TrustStore = false;
            }
            catch (IOException e3) {
                iOErrorMessage = "Cannot write TrustStore to disk. ";
            }
        }
        if (modified_CertStore) {
            try {
                CertStore.store();
                modified_CertStore = false;
            }
            catch (IOException e4) {
                iOErrorMessage = "Cannot write CertStore to disk. ";
            }
        }
        if (modified_CRLManager) {
            try {
                CRLManager.save();
                modified_CRLManager = false;
            }
            catch (IOException e5) {
                iOErrorMessage = "Cannot write CRLManager to disk. ";
            }
        }
        if (iOErrorMessage != null) {
            throw new InternalErrorException(iOErrorMessage);
        }
    }

    public static void storeTrustStore() throws IOException {
        TrustStore.store();
        modified_TrustStore = false;
    }

    public static synchronized void storeCertStore() throws IOException {
        CertStore.store();
        modified_CertStore = false;
    }

    public static synchronized void storeTrustEnv() throws IOException {
        TrustEnv.store();
        modified_TrustEnv = false;
    }

    public static int getTrustStatus(X509Certificate cert) throws TransientTmException {
        TrustRecord trustRecord = TrustStore.getTrustRecord(cert);
        if (trustRecord != null) {
            TrustProperties trustProperties = trustRecord.getTrustProperties();
            if (trustProperties.isTrusted()) {
                return 1;
            }
            if (trustProperties.isMistrusted()) {
                return 2;
            }
        }
        X509Certificate[] certChain = Trustmanager.getCertificateChain(cert);
        for (int i = 1; i < certChain.length; ++i) {
            trustRecord = TrustStore.getTrustRecord(certChain[i]);
            if (trustRecord == null) continue;
            TrustProperties trustProperties = trustRecord.getTrustProperties();
            if (trustProperties.isTrusted()) {
                return 3;
            }
            if (!trustProperties.isMistrusted()) continue;
            return 4;
        }
        return 0;
    }

    public static int getExplicitTrustStatus(X509Certificate cert) {
        TrustRecord trustRecord = TrustStore.getTrustRecord(cert);
        if (trustRecord != null) {
            TrustProperties trustProperties = trustRecord.getTrustProperties();
            if (trustProperties.isTrusted()) {
                return 1;
            }
            if (trustProperties.isMistrusted()) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public static TrustedKeyUsage getTrustedKeyUsage(X509Certificate cert) throws TransientTmException {
        PurposeProperties pProps = null;
        TrustRecord trustRecord = TrustStore.getTrustRecord(cert);
        if (trustRecord != null && trustRecord.getTrustProperties().isTrusted()) {
            pProps = trustRecord.getPurposeProperties();
            TrustedKeyUsage result = new TrustedKeyUsage();
            if (pProps.isDigitalSignature()) {
                result.digitalSignature = true;
            }
            if (pProps.isNonRepudiation()) {
                result.nonRepudiation = true;
            }
            if (pProps.isKeyAgreement() || pProps.isEncipherOnly() || pProps.isDecipherOnly() || pProps.isKeyEncipherment() || pProps.isDataEncipherment()) {
                result.encipherment = true;
            }
            if (pProps.isKeyCertSign()) {
                result.keyCertSign = true;
            }
            if (pProps.isCRLSign()) {
                result.cRLSign = true;
            }
            if (pProps.isWebServerAuthen()) {
                result.webServerAuthen = true;
            }
            if (pProps.isWebClientAuthen()) {
                result.webClientAuthen = true;
            }
            if (pProps.isCodeSigning()) {
                result.codeSigning = true;
            }
            if (pProps.isEMailProtection()) {
                result.eMailProtection = true;
            }
            if (pProps.isTimeStamping()) {
                result.timeStamping = true;
            }
            return result;
        }
        X509Certificate[] certChain = Trustmanager.getCertificateChain(cert);
        for (int i = 1; i < certChain.length && pProps == null; ++i) {
            trustRecord = TrustStore.getTrustRecord(certChain[i]);
            if (trustRecord == null || !trustRecord.getTrustProperties().isTrusted()) continue;
            pProps = trustRecord.getPurposeProperties();
        }
        if (pProps == null) {
            return null;
        }
        TrustedKeyUsage result = new TrustedKeyUsage();
        if (TrustmanagerUtils.isCA(cert)) {
            if (pProps.isKeyAgreement() || pProps.isEncipherOnly() || pProps.isDecipherOnly() || pProps.isKeyEncipherment() || pProps.isDataEncipherment()) {
                result.encipherment = true;
            }
            if (pProps.isDigitalSignature()) {
                result.digitalSignature = true;
            }
            if (pProps.isNonRepudiation()) {
                result.nonRepudiation = true;
            }
            if (pProps.isKeyCertSign()) {
                result.keyCertSign = true;
            }
            if (pProps.isCRLSign()) {
                result.cRLSign = true;
            }
            if (pProps.isWebServerAuthen()) {
                result.webServerAuthen = true;
            }
            if (pProps.isWebClientAuthen()) {
                result.webClientAuthen = true;
            }
            if (pProps.isCodeSigning()) {
                result.codeSigning = true;
            }
            if (pProps.isEMailProtection()) {
                result.eMailProtection = true;
            }
            if (pProps.isTimeStamping()) {
                result.timeStamping = true;
            }
        } else {
            String keyAlgorithm;
            if (pProps.isKeyAgreement() || pProps.isEncipherOnly() || pProps.isDecipherOnly() || pProps.isKeyEncipherment() || pProps.isDataEncipherment()) {
                result.encipherment = true;
            }
            if (pProps.isDigitalSignature()) {
                result.digitalSignature = true;
            }
            if (pProps.isNonRepudiation()) {
                result.nonRepudiation = true;
            }
            if (pProps.isKeyCertSign()) {
                result.keyCertSign = true;
            }
            if (pProps.isCRLSign()) {
                result.cRLSign = true;
            }
            if (pProps.isWebServerAuthen()) {
                result.webServerAuthen = true;
            }
            if (pProps.isWebClientAuthen()) {
                result.webClientAuthen = true;
            }
            if (pProps.isCodeSigning()) {
                result.codeSigning = true;
            }
            if (pProps.isEMailProtection()) {
                result.eMailProtection = true;
            }
            if (pProps.isTimeStamping()) {
                result.timeStamping = true;
            }
            boolean kU_is_present = false;
            boolean[] keyUsage = cert.getKeyUsage();
            if (keyUsage != null) {
                kU_is_present = true;
            }
            boolean eKU_is_present = false;
            int eKeyUsage = TrustmanagerUtils.getExtKeyUsage(cert);
            if ((eKeyUsage & 1) != 0) {
                eKU_is_present = true;
            }
            if (kU_is_present) {
                if (result.digitalSignature) {
                    result.digitalSignature = keyUsage[0];
                }
                if (result.nonRepudiation) {
                    result.nonRepudiation = keyUsage[1];
                }
                if (result.encipherment) {
                    result.encipherment = keyUsage[2] | keyUsage[3] | keyUsage[4] | keyUsage[7] | keyUsage[8];
                }
                if (result.cRLSign) {
                    result.cRLSign = keyUsage[6];
                }
                if (result.keyCertSign) {
                    result.keyCertSign = keyUsage[5];
                }
            } else {
                result.nonRepudiation = false;
            }
            if (eKU_is_present) {
                if ((eKeyUsage & 0x10) != 0) {
                    result.eMailProtection = false;
                }
                if ((eKeyUsage & 8) != 0) {
                    result.codeSigning = false;
                }
                if ((eKeyUsage & 2) != 0) {
                    result.webServerAuthen = false;
                }
                if ((eKeyUsage & 0x20) != 0) {
                    result.timeStamping = false;
                }
                if ((eKeyUsage & 4) != 0) {
                    result.webClientAuthen = false;
                }
            }
            if ((keyAlgorithm = TrustmanagerUtils.getKeyAlgorithm(cert)).startsWith("DSA")) {
                result.encipherment = false;
            } else if (keyAlgorithm.startsWith("Diffie-Hellman")) {
                result.digitalSignature = true;
                result.nonRepudiation = true;
                result.keyCertSign = true;
                result.cRLSign = true;
                result.webServerAuthen = true;
                result.webClientAuthen = true;
                result.codeSigning = true;
                result.eMailProtection = true;
                result.timeStamping = true;
            }
        }
        return result;
    }

    public static void putTrustRecord(TrustRecord trustRecord) {
        modified_TrustStore = true;
        TrustStore.putTrustRecord(trustRecord);
    }

    public static void putCertificate(X509Certificate cert) {
        modified_TrustEnv = true;
        TrustEnv.lastImportedCert = TrustmanagerUtils.makeCertHash(cert);
        modified_CertStore = true;
        CertStore.putCertificate(cert);
        TrustRecord trustRecord = TrustStore.getTrustRecord(cert);
        if (trustRecord == null) {
            modified_TrustStore = true;
            trustRecord = new TrustRecord(cert);
            TrustStore.putTrustRecord(trustRecord);
        }
    }

    public static byte[] getHashofLastImportedCert() {
        byte[] certHash = TrustEnv.lastImportedCert;
        if (certHash != null) {
            modified_TrustEnv = true;
            TrustEnv.lastImportedCert = null;
        }
        return certHash;
    }

    public static X509Certificate[] putCertificates(X509Certificate[] certArray) throws IOException {
        if (certArray != null && certArray.length > 0) {
            for (int i = 0; i < certArray.length; ++i) {
                Trustmanager.putCertificate(certArray[i]);
            }
            return null;
        }
        return null;
    }

    private static Vector getCertificatesFromLocalDirs() throws TransientTmException {
        if (TrustEnv.localDirs_are_available) {
            LocalLDAP localLDAP = new LocalLDAP();
            localLDAP.establishConnection(3);
            while (!localLDAP.done()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    throw new InternalError(e2.getMessage());
                }
            }
            localLDAP.stop();
            Vector errorMessages = localLDAP.getErrorMessages();
            if (errorMessages.size() > 0) {
                if (TrustEnv.isGUI) {
                    throw new TransientTmException((String)errorMessages.elementAt(0));
                }
                TrustEnv.localDirs_are_available = false;
            }
            return localLDAP.getCertificates();
        }
        return new Vector();
    }

    public static X509Certificate[] getCertificates(String email) throws TransientTmException {
        int i;
        X509Certificate[] certArray1 = CertStore.getCertificates(email);
        Vector certVector = Trustmanager.getCertificatesFromLocalDirs();
        int index = 0;
        while (index < certVector.size()) {
            X509Certificate cert = (X509Certificate)certVector.elementAt(index);
            String[] emails = X500Utils.getEMail(cert);
            if (emails != null && emails.length > 0) {
                boolean email_found = false;
                for (int i2 = 0; i2 < emails.length; ++i2) {
                    if (!emails[i2].equals(email)) continue;
                    email_found = true;
                }
                if (email_found) {
                    ++index;
                    Trustmanager.putCertificate(cert);
                    continue;
                }
                certVector.removeElementAt(index);
                continue;
            }
            certVector.removeElementAt(index);
        }
        if (certVector.size() == 0 && certArray1 == null) {
            return null;
        }
        if (certVector.size() == 0) {
            return certArray1;
        }
        if (certArray1 == null) {
            X509Certificate[] result = new X509Certificate[certVector.size()];
            for (int i3 = 0; i3 < certVector.size(); ++i3) {
                result[i3] = (X509Certificate)certVector.elementAt(i3);
            }
            return result;
        }
        X509Certificate[] resultArray = new X509Certificate[certArray1.length + certVector.size()];
        for (i = 0; i < certArray1.length; ++i) {
            resultArray[i] = certArray1[i];
        }
        for (i = certArray1.length; i < certArray1.length + certVector.size(); ++i) {
            resultArray[i] = (X509Certificate)certVector.elementAt(i - certArray1.length);
        }
        return resultArray;
    }

    public static X509Certificate[] getCertificates(Name subject) throws TransientTmException {
        X509Certificate[] certArray1 = CertStore.getCertificates(subject);
        if (certArray1 != null && certArray1.length > 0) {
            return certArray1;
        }
        return null;
    }

    public static X509Certificate[] getCertificateChain(X509Certificate cert) throws TransientTmException {
        if (TrustmanagerUtils.isRootCA(cert)) {
            X509Certificate[] result = new X509Certificate[]{cert};
            return result;
        }
        boolean chain_end_found = false;
        Vector<Object> certVector = new Vector<Object>();
        certVector.addElement(cert);
        int index = 0;
        while (!chain_end_found) {
            Name issuer = (Name)((X509Certificate)certVector.elementAt(index)).getIssuerDN();
            X509Certificate[] certArray = Trustmanager.getCertificates(issuer);
            if (certArray == null || certArray.length == 0) {
                chain_end_found = true;
                continue;
            }
            Vector<X509Certificate> parentCerts = new Vector<X509Certificate>();
            for (int i = 0; i < certArray.length; ++i) {
                try {
                    ((X509Certificate)certVector.elementAt(index)).verify(certArray[i].getPublicKey(), "IAIK");
                    parentCerts.addElement(certArray[i]);
                    continue;
                }
                catch (SignatureException signatureException) {
                    continue;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new InternalErrorException(e2.getMessage());
                }
            }
            if (parentCerts.size() > 1) {
                int explicitTrust = 0;
                Vector parentCerts_important = new Vector();
                for (int i = 0; i < parentCerts.size(); ++i) {
                    int explicitTrust_temp = Trustmanager.getExplicitTrustStatus((X509Certificate)parentCerts.elementAt(i));
                    if (explicitTrust_temp == 2) {
                        explicitTrust = 2;
                        parentCerts_important.removeAllElements();
                        parentCerts_important.addElement(parentCerts.elementAt(i));
                    }
                    if (explicitTrust_temp == 1 && explicitTrust != 2) {
                        explicitTrust = 1;
                        parentCerts_important.removeAllElements();
                        parentCerts_important.addElement(parentCerts.elementAt(i));
                    }
                    if (explicitTrust_temp != 0 || explicitTrust != 0) continue;
                    explicitTrust = 0;
                    parentCerts_important.addElement(parentCerts.elementAt(i));
                }
                if (explicitTrust == 2) {
                    certVector.addElement(parentCerts_important.elementAt(0));
                    chain_end_found = true;
                    continue;
                }
                if (explicitTrust == 1) {
                    certVector.addElement(parentCerts_important.elementAt(0));
                    chain_end_found = true;
                    continue;
                }
                certVector.addElement(parentCerts_important.elementAt(0));
                if (TrustmanagerUtils.isRootCA((X509Certificate)parentCerts_important.elementAt(0))) {
                    chain_end_found = true;
                    continue;
                }
                ++index;
                continue;
            }
            if (parentCerts.size() == 1) {
                certVector.addElement(parentCerts.elementAt(0));
                if (TrustmanagerUtils.isRootCA((X509Certificate)parentCerts.elementAt(0))) {
                    chain_end_found = true;
                    continue;
                }
                ++index;
                continue;
            }
            chain_end_found = true;
        }
        X509Certificate[] result = new X509Certificate[certVector.size()];
        for (int i = 0; i < certVector.size(); ++i) {
            result[i] = (X509Certificate)certVector.elementAt(i);
        }
        return result;
    }

    public static X509Certificate[] getTrustedCertChain(X509Certificate cert) throws TransientTmException {
        boolean isTrusted = false;
        Vector<X509Certificate> certVector = new Vector<X509Certificate>();
        X509Certificate chainElement = cert;
        while (chainElement != null && !isTrusted) {
            certVector.addElement(chainElement);
            TrustRecord tR = TrustStore.getTrustRecord(chainElement);
            if (tR != null && tR.getTrustProperties().isTrusted()) {
                isTrusted = true;
                continue;
            }
            chainElement = Trustmanager.getCACertificate(chainElement);
        }
        if (isTrusted) {
            X509Certificate[] certChain = new X509Certificate[certVector.size()];
            for (int i = 0; i < certVector.size(); ++i) {
                certChain[i] = (X509Certificate)certVector.elementAt(i);
            }
            return certChain;
        }
        return null;
    }

    public static X509Certificate getCACertificate(X509Certificate cert) throws TransientTmException {
        if (cert == null) {
            throw new InternalErrorException("Certificate must be specified. ");
        }
        if (TrustmanagerUtils.isRootCA(cert)) {
            return null;
        }
        Name issuer = (Name)cert.getIssuerDN();
        X509Certificate[] certArray = Trustmanager.getCertificates(issuer);
        if (certArray == null || certArray.length == 0) {
            return null;
        }
        for (int i = 0; i < certArray.length; ++i) {
            try {
                cert.verify(certArray[i].getPublicKey(), "IAIK");
                X509Certificate x509Certificate = certArray[i];
                return x509Certificate;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static void removeCertificate(X509Certificate cert) {
        modified_CertStore = true;
        modified_TrustStore = true;
        TrustStore.removeTrustRecord(cert);
        CertStore.removeCertificate(cert);
    }

    public static void removeTrustRecord(TrustRecord trustRecord) {
        modified_TrustStore = true;
        TrustStore.removeTrustRecord(trustRecord);
    }

    public static Hashtable getCertificates() throws TransientTmException {
        if (TrustEnv.isGUI && !TrustEnv.isViewCACerts() && !TrustEnv.isViewEECerts() || !TrustEnv.isViewLocalCerts() && !TrustEnv.isViewLocalDirCerts()) {
            return new Hashtable();
        }
        Hashtable<String, X509Certificate> certHashtable = null;
        certHashtable = TrustEnv.isGUI && !TrustEnv.isViewLocalCerts() ? new Hashtable<String, X509Certificate>() : CertStore.getCertificates();
        if (!(!TrustEnv.isGUI || TrustEnv.isViewCACerts() && TrustEnv.isViewEECerts())) {
            Enumeration enumeration = certHashtable.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                X509Certificate cert = (X509Certificate)certHashtable.get(key);
                boolean isCACert = TrustmanagerUtils.isCA(cert);
                if (TrustEnv.isViewCACerts() && !isCACert) {
                    certHashtable.remove(key);
                }
                if (!TrustEnv.isViewEECerts() || !isCACert) continue;
                certHashtable.remove(key);
            }
        }
        if (!TrustEnv.isGUI && TrustEnv.localDirs_are_available || TrustEnv.isViewLocalDirCerts()) {
            int certType = 3;
            if (TrustEnv.isGUI && TrustEnv.isViewCACerts() && !TrustEnv.isViewEECerts()) {
                certType = 2;
            } else if (TrustEnv.isGUI && TrustEnv.isViewEECerts() && !TrustEnv.isViewCACerts()) {
                certType = 1;
            }
            LocalLDAP localLDAP = new LocalLDAP();
            localLDAP.establishConnection(certType);
            while (!localLDAP.done()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    throw new InternalError(e2.getMessage());
                }
            }
            localLDAP.stop();
            Vector errorMessages = localLDAP.getErrorMessages();
            if (errorMessages.size() > 0) {
                if (TrustEnv.isGUI) {
                    throw new TransientTmException((String)errorMessages.elementAt(0));
                }
                TrustEnv.localDirs_are_available = false;
            }
            Vector certs = localLDAP.getCertificates();
            for (int i = 0; i < certs.size(); ++i) {
                X509Certificate cert = (X509Certificate)certs.elementAt(i);
                String alias = new String(TrustmanagerUtils.makeCertHash(cert));
                certHashtable.put(alias, cert);
            }
        }
        return certHashtable;
    }

    public TrustRecord[] getTrustRecords() {
        return null;
    }

    public static RevocationStatus getRevocationStatus(X509Certificate cert, Date date) throws TransientTmException, IOException, TrustmanagerException {
        int i;
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified when verifying revocation. ");
        }
        X509Certificate[] certChain = Trustmanager.getTrustedCertChain(cert);
        if (certChain == null) {
            return new RevocationStatus(64, null, null, null, null, ReasonCode.unspecified, null);
        }
        TrustRecord[] trustArray = new TrustRecord[certChain.length];
        for (i = 0; i < certChain.length; ++i) {
            trustArray[i] = TrustStore.getTrustRecord(certChain[i]);
        }
        if (date == null) {
            date = TrustedTime.getCurrentTime();
        } else {
            for (i = 0; i < certChain.length; ++i) {
                if (trustArray[i] == null) {
                    date = TrustedTime.getCurrentTime();
                    continue;
                }
                Date trustRecordDate = trustArray[i].getDate();
                if (trustRecordDate.getTime() <= date.getTime()) continue;
                date = new Date(trustRecordDate.getTime() + (long)1);
            }
        }
        for (i = certChain.length - 1; i >= 0; --i) {
            RevocationInfo rInfo;
            if (trustArray[i] != null && (rInfo = trustArray[i].getRevocationInfo()) != null && rInfo.isRevoked()) {
                if (i == 0) {
                    return new RevocationStatus(32, null, null, rInfo.getRevokedSince(), rInfo.getInvalidSince(), rInfo.getReasonCode(), null);
                }
                return new RevocationStatus(32, null, null, rInfo.getRevokedSince(), rInfo.getInvalidSince(), rInfo.getReasonCode(), TrustmanagerUtils.getCertificateName(certChain[i]));
            }
            boolean verifyRevocation = true;
            if (trustArray[i] != null && !trustArray[i].getTrustProperties().isRevVerificationSet()) {
                verifyRevocation = false;
            }
            if (i < certChain.length - 1 && trustArray[i + 1] != null && !trustArray[i + 1].getTrustProperties().isRevVerificationIssuedCerts()) {
                verifyRevocation = false;
            }
            if (verifyRevocation) {
                RevocationStatus localRStatus = null;
                if (trustArray[i] != null && !trustArray[i].getTrustProperties().isAlwaysGetLatestRevInfo()) {
                    localRStatus = Trustmanager.getLocalRevocationInfo(certChain[i], date);
                    if (localRStatus.status == 32) {
                        if (i > 0) {
                            localRStatus.inherited_from = TrustmanagerUtils.getCertificateName(certChain[i]);
                        }
                        return localRStatus;
                    }
                }
                if (localRStatus == null || localRStatus.status != 1) {
                    RevocationInfo rInfo2;
                    RevocationStatus remoteRStatus = Trustmanager.getRemoteRevocationInfo(certChain[i], date);
                    if (remoteRStatus.status == 1) {
                        rInfo2 = new RevocationInfo();
                        rInfo2.clearRevoked();
                        rInfo2.setThisUpdate(date);
                        rInfo2.setNextUpdate(remoteRStatus.status_valid_till);
                        if (trustArray[i] == null) {
                            trustArray[i] = new TrustRecord(certChain[i]);
                        }
                    } else {
                        if (remoteRStatus.status == 32) {
                            rInfo2 = new RevocationInfo();
                            rInfo2.setRevoked();
                            rInfo2.setThisUpdate(date);
                            rInfo2.setRevokedSince(remoteRStatus.revoked_since);
                            rInfo2.setInvalidSince(remoteRStatus.invalid_since);
                            rInfo2.setReasonCode(remoteRStatus.reasonCode);
                            if (trustArray[i] == null) {
                                trustArray[i] = new TrustRecord(certChain[i]);
                            }
                            trustArray[i].setRevocationInfo(rInfo2);
                            Trustmanager.putTrustRecord(trustArray[i]);
                            Trustmanager.store_if_necessary();
                            if (i > 0) {
                                String[] cNs = X500Utils.getCommonName(certChain[i]);
                                remoteRStatus.inherited_from = cNs[0];
                            }
                            return remoteRStatus;
                        }
                        if (i > 0) {
                            remoteRStatus.inherited_from = TrustmanagerUtils.getCertificateName(certChain[i]);
                        }
                        return remoteRStatus;
                    }
                    trustArray[i].setRevocationInfo(rInfo2);
                    Trustmanager.putTrustRecord(trustArray[i]);
                    Trustmanager.store_if_necessary();
                    if (i != 0) continue;
                    return remoteRStatus;
                }
                if (i != 0) continue;
                return localRStatus;
            }
            if (i != 0) continue;
            return new RevocationStatus(2, null, null, null, null, ReasonCode.unspecified, null);
        }
        throw new InternalErrorException("Verifying Revocation status failed. ");
    }

    protected static RevocationStatus getLocalRevocationInfo(X509Certificate cert, Date date) {
        TrustRecord tR;
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        if (date == null) {
            date = TrustedTime.getCurrentTime();
        }
        if ((tR = TrustStore.getTrustRecord(cert)) == null) {
            return new RevocationStatus(16, null, null, null, null, ReasonCode.unspecified, null);
        }
        RevocationInfo rI = tR.getRevocationInfo();
        if (rI == null) {
            return new RevocationStatus(16, null, null, null, null, ReasonCode.unspecified, null);
        }
        RevocationStatus rStatus = new RevocationStatus();
        if (rI.isRevoked()) {
            rStatus.revoked_since = rI.getRevokedSince();
            rStatus.invalid_since = rI.getInvalidSince();
            rStatus.reasonCode = rI.getReasonCode();
            rStatus.status = date.getTime() > rStatus.revoked_since.getTime() ? 32 : 1;
            return rStatus;
        }
        if (rI.getNextUpdate().getTime() > date.getTime()) {
            rStatus.status = 1;
            rStatus.status_valid_till = rI.getNextUpdate();
            return rStatus;
        }
        rStatus.status = 4;
        rStatus.rev_info_out_of_date_since = rI.getNextUpdate();
        return rStatus;
    }

    protected static RevocationStatus getRemoteRevocationInfo(X509Certificate cert, Date date) throws TransientTmException, TrustmanagerException {
        if (cert == null) {
            throw new NullPointerException("There is no certificate specified. ");
        }
        if (date == null) {
            date = TrustedTime.getCurrentTime();
        }
        X509CRL crl = null;
        X509Certificate cACert = Trustmanager.getCACertificate(cert);
        if (cACert == null) {
            return new RevocationStatus(16, null, null, null, null, ReasonCode.unspecified, null);
        }
        try {
            crl = CRLManager.getCRL(cert);
        }
        catch (TransientTmException transientTmException) {
            // empty catch block
        }
        if (crl == null) {
            return new RevocationStatus(16, null, null, null, null, ReasonCode.unspecified, null);
        }
        if (crl.isRevoked((Certificate)cert)) {
            RevocationStatus rStatus = new RevocationStatus();
            RevokedCertificate crlEntry = (RevokedCertificate)crl.getRevokedCertificate(cert.getSerialNumber());
            rStatus.revoked_since = crlEntry.getRevocationDate();
            rStatus.status = rStatus.revoked_since.getTime() > date.getTime() ? 1 : 32;
            rStatus.invalid_since = null;
            try {
                ReasonCode reasonCode = (ReasonCode)crlEntry.getExtension(ReasonCode.oid);
                rStatus.reasonCode = reasonCode.getReasonCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rStatus;
        }
        Date cRLDate = crl.getNextUpdate();
        if (cRLDate.getTime() < date.getTime()) {
            return new RevocationStatus(4, null, cRLDate, null, null, ReasonCode.unspecified, null);
        }
        return new RevocationStatus(1, cRLDate, null, null, null, ReasonCode.unspecified, null);
    }

    public static int getExpirationWarningPeriod() {
        return TrustEnv.getExpirationWarningPeriod();
    }

    public static void setExpirationWarningPeriod(int days) {
        modified_TrustEnv = true;
        TrustEnv.setExpirationWarningPeriod(days);
    }

    public static synchronized String getImportDirectory() {
        return TrustEnv.getImportDirectory();
    }

    public static synchronized void setImportDirectory(String dir) {
        modified_TrustEnv = true;
        TrustEnv.setImportDirectory(dir);
    }

    public static synchronized String getExportDirectory() {
        return TrustEnv.getExportDirectory();
    }

    public static synchronized void setExportDirectory(String dir) {
        modified_TrustEnv = true;
        TrustEnv.setExportDirectory(dir);
    }

    public static String[][] getLocalDirectories() {
        return TrustEnv.getLocalDirectories();
    }

    public static void addLocalDirectory(String url, String dn, String userName, char[] pwd, String version) {
        modified_TrustEnv = true;
        TrustEnv.addLocalDirectory(url, dn, userName, pwd, version);
    }

    public static void removeLocalDirectory(int index) {
        modified_TrustEnv = true;
        TrustEnv.removeLocalDirectory(index);
    }

    public static void swapLocalDirectories(int firstIndex, int secondIndex) {
        modified_TrustEnv = true;
        TrustEnv.swapLocalDirectories(firstIndex, secondIndex);
    }

    public static String[][] getGlobalDirectories() {
        return TrustEnv.getGlobalDirectories();
    }

    public static void addGlobalDirectory(String url, String dn, String userName, char[] pwd, String version) {
        modified_TrustEnv = true;
        TrustEnv.addGlobalDirectory(url, dn, userName, pwd, version);
    }

    public static void removeGlobalDirectory(int index) {
        modified_TrustEnv = true;
        TrustEnv.removeGlobalDirectory(index);
    }

    public static void swapGlobalDirectories(int firstIndex, int secondIndex) {
        modified_TrustEnv = true;
        TrustEnv.swapGlobalDirectories(firstIndex, secondIndex);
    }

    public static int getValidityStatus(X509Certificate cert, Date date) throws TransientTmException {
        long beginOfValidity = cert.getNotBefore().getTime();
        long endOfValidity = cert.getNotAfter().getTime();
        long validationDate = date == null ? TrustedTime.getCurrentTime().getTime() : date.getTime();
        long expirationWarningPeriod = new Integer(Trustmanager.getExpirationWarningPeriod()).longValue() * (long)86400000;
        if (validationDate < beginOfValidity) {
            return ValidityStatus.NOT_VALID_YET;
        }
        if (validationDate > endOfValidity) {
            return ValidityStatus.EXPIRED;
        }
        if (validationDate > endOfValidity - expirationWarningPeriod) {
            return ValidityStatus.EXPIRING_SOON;
        }
        return ValidityStatus.VALID;
    }

    public static String[] getEmailAdresses() {
        Hashtable certs = CertStore.getCertificates();
        Hashtable<String, String> emails = new Hashtable<String, String>();
        Enumeration enumeration = certs.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate cert = (X509Certificate)enumeration.nextElement();
            Name subject = (Name)cert.getSubjectDN();
            String[] emailAddresses = subject.getRDNs(ObjectID.emailAddress);
            if (emailAddresses != null && emailAddresses.length > 0) {
                for (int i = 0; i < emailAddresses.length; ++i) {
                    String email = emailAddresses[i];
                    email = email.trim();
                    email = email.toLowerCase();
                    emails.put(email, email);
                }
            }
            try {
                SubjectAltName subAlt = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
                if (subAlt == null) continue;
                GeneralNames generalNames = subAlt.getGeneralNames();
                Enumeration generalNames_enum = generalNames.getNames();
                while (generalNames_enum.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)generalNames_enum.nextElement();
                    if (generalName.getType() != GeneralName.rfc822Name) continue;
                    String email = (String)generalName.getName();
                    email = email.trim();
                    email = email.toLowerCase();
                    emails.put(email, email);
                }
            }
            catch (Exception subAlt) {
            }
        }
        int number = emails.size();
        if (number > 0) {
            String[] result = new String[number];
            Enumeration result_enum = emails.elements();
            int i = 0;
            while (result_enum.hasMoreElements()) {
                result[i] = (String)result_enum.nextElement();
                ++i;
            }
            return result;
        }
        return null;
    }

    public static void setDistributionPoint(X509Certificate cert, String lDAP_URL, String dN, String hTTP_URL) {
        modified_CRLManager = true;
        CRLManager.setDistributionPoint(cert, lDAP_URL, dN, hTTP_URL);
    }

    public static CRLDistributionPoint getDistributionPoint(X509Certificate cert) {
        return CRLManager.getDistributionPoint(cert);
    }

    public static void putCRL(X509CRL crl) throws IOException {
        CRLManager.putCRL(crl);
    }

    public static Hashtable getDistributionPoints() {
        return CRLManager.getDistributionPoints();
    }

    public static void removeCRLDistributionPoint(String issuer) {
        modified_CRLManager = true;
        CRLManager.removeCRLDistributionPoint(issuer);
    }
}

