/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.api;

import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.TrustmanagerPolicyException;
import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.api.Trustmanager;
import iaik.apps.trustmanager.time.TrustedTime;
import iaik.apps.trustmanager.utils.Integrity;
import iaik.apps.trustmanager.utils.SwingWorker;
import iaik.utils.InternalErrorException;
import java.io.IOException;

public class InitTrustmanager {
    private static final boolean DEBUG = false;
    private int lengthOfTask = 100;
    private boolean finished = false;
    private int current = 0;
    private String statMessage;
    private char[] pwd;
    private String filename;
    private String iOExceptionMessage = null;
    private String trustmanagerExceptionMessage = null;
    private String trustmanagerPolicyExceptionMessage = null;

    public InitTrustmanager() {
        throw new InternalErrorException("Do not use this method. Password and location of configuration file must be specified for initializing the Trustmanager. ");
    }

    public InitTrustmanager(String filename, char[] password) {
        this.pwd = password;
        this.filename = filename;
    }

    public void go() throws TrustmanagerPolicyException, TrustmanagerException, IOException {
        this.current = 0;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new ActualInitMethod(InitTrustmanager.this);
            }
        };
        if (this.trustmanagerExceptionMessage != null) {
            throw new IOException(this.trustmanagerExceptionMessage);
        }
        if (this.iOExceptionMessage != null) {
            throw new IOException(this.iOExceptionMessage);
        }
        if (this.trustmanagerPolicyExceptionMessage != null) {
            throw new TrustmanagerPolicyException(this.trustmanagerPolicyExceptionMessage);
        }
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
    }

    public boolean done() throws TrustmanagerPolicyException, TrustmanagerException, IOException {
        if (this.iOExceptionMessage != null) {
            throw new IOException(this.iOExceptionMessage);
        }
        if (this.trustmanagerExceptionMessage != null) {
            throw new TrustmanagerException(this.trustmanagerExceptionMessage);
        }
        if (this.trustmanagerPolicyExceptionMessage != null) {
            throw new TrustmanagerPolicyException(this.trustmanagerPolicyExceptionMessage);
        }
        return this.finished;
    }

    public String getMessage() {
        return this.statMessage;
    }

    class ActualInitMethod {
        ActualInitMethod(InitTrustmanager this$0) {
            while (!this$0.finished) {
                block8: {
                    try {
                        this$0.current = 3;
                        this$0.statMessage = "Verifying password ... ";
                        if (this$0.pwd != null) {
                            Integrity.setPassword(this$0.pwd);
                        }
                        this$0.current = 6;
                        this$0.statMessage = "Initializing trusted time ... ";
                        TrustedTime.init(null, null);
                        this$0.current = 10;
                        this$0.statMessage = "Initializing Trustmanager ... ";
                        TrustEnv.load(this$0.filename);
                        TrustEnv.setViewCACerts(true);
                        TrustEnv.setViewEECerts(true);
                        TrustEnv.setViewLocalCerts(true);
                        TrustEnv.setViewLocalDirCerts(false);
                        this$0.current = 20;
                        this$0.statMessage = "Reading trust settings ... ";
                        Trustmanager.loadTrustStore();
                        this$0.current = 50;
                        this$0.statMessage = "Reading certificates ... ";
                        Trustmanager.loadCertStore();
                        this$0.current = 80;
                        this$0.statMessage = "Initializing revocation information ... ";
                        Trustmanager.initCRLManager();
                        this$0.current = 90;
                        this$0.statMessage = "Deriving new password based key ... ";
                        byte[] salt = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 56, 55, 54, 53, 52, 51, 50};
                        Integrity.updatePBEKey(salt);
                        this$0.current = 100;
                        this$0.statMessage = "Initializing Trustmanager complete. ";
                    }
                    catch (TrustmanagerPolicyException e2) {
                        this$0.finished = true;
                        this$0.trustmanagerPolicyExceptionMessage = e2.getMessage();
                        if (this$0.trustmanagerPolicyExceptionMessage == null) {
                            this$0.trustmanagerPolicyExceptionMessage = " ";
                        }
                    }
                    catch (IOException e3) {
                        this$0.finished = true;
                        this$0.iOExceptionMessage = e3.getMessage();
                        if (this$0.iOExceptionMessage == null) {
                            this$0.iOExceptionMessage = " ";
                        }
                    }
                    catch (TrustmanagerException e4) {
                        this$0.finished = true;
                        this$0.trustmanagerExceptionMessage = e4.getMessage();
                        if (this$0.trustmanagerExceptionMessage != null) break block8;
                        this$0.trustmanagerExceptionMessage = " ";
                    }
                }
                this$0.finished = true;
            }
        }
    }
}

