/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager;

import iaik.apps.trustmanager.RevocationStatus;
import iaik.apps.trustmanager.TransientTmException;
import iaik.apps.trustmanager.TrustedKeyUsage;
import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.TrustmanagerPolicyException;
import iaik.apps.trustmanager.api.Trustmanager;
import iaik.asn1.structures.Name;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

public final class TrustmanagerAPI {
    private boolean isInitialized = false;

    public boolean isModified() {
        return Trustmanager.isModified();
    }

    public void load(String filename, char[] password) throws TrustmanagerException, IOException, TrustmanagerPolicyException {
        Trustmanager.load(filename, password);
        this.isInitialized = true;
    }

    public void store() throws IOException {
        if (!this.isInitialized) {
            throw new IOException("Trustmanager has not been loaded, yet. ");
        }
        Trustmanager.store();
    }

    public static void changePassword(char[] oldPwd, char[] newPwd) throws IOException, TrustmanagerPolicyException, TrustmanagerException {
        Trustmanager.changePassword(oldPwd, newPwd);
    }

    public boolean isTrusted(X509Certificate cert) throws TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        int trustStatus = Trustmanager.getTrustStatus(cert);
        return trustStatus == 1 || trustStatus == 3;
    }

    public TrustedKeyUsage getTrustedKeyUsage(X509Certificate cert) throws TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        return Trustmanager.getTrustedKeyUsage(cert);
    }

    public void putCertificate(X509Certificate cert) throws IOException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        Trustmanager.putCertificate(cert);
    }

    public void putCertificates(X509Certificate[] certArray) throws IOException {
        if (certArray == null) {
            throw new NullPointerException("Certificate array must be specified. ");
        }
        Trustmanager.putCertificates(certArray);
    }

    public void putCRL(X509CRL crl) throws IOException {
        if (crl == null) {
            throw new NullPointerException("CRL must be specified. ");
        }
        Trustmanager.putCRL(crl);
    }

    public X509Certificate[] getCertificates(String email) throws TransientTmException {
        if (email == null) {
            throw new NullPointerException("Email must be specified. ");
        }
        return Trustmanager.getCertificates(email);
    }

    public X509Certificate[] getCertificates(Name subject) throws TransientTmException {
        if (subject == null) {
            throw new NullPointerException("Subject DN must be specified. ");
        }
        return Trustmanager.getCertificates(subject);
    }

    public Hashtable getCertificates() throws TransientTmException {
        return Trustmanager.getCertificates();
    }

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        return Trustmanager.getCertificateChain(cert);
    }

    public X509Certificate[] getTrustedCertChain(X509Certificate cert) throws TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        return Trustmanager.getTrustedCertChain(cert);
    }

    public RevocationStatus getRevocationStatus(X509Certificate cert, Date date) throws IOException, TrustmanagerException, TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        return Trustmanager.getRevocationStatus(cert, date);
    }

    public int getValidityStatus(X509Certificate cert, Date date) throws TransientTmException {
        if (cert == null) {
            throw new NullPointerException("Certificate must be specified. ");
        }
        return Trustmanager.getValidityStatus(cert, date);
    }

    public String[] getEmailAdresses() {
        return Trustmanager.getEmailAdresses();
    }
}

