/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.repository;

import cybertrust2.repository.RepositoryException;
import cybertrust2.repository.e;
import iaik.apps.trustmanager.RevocationStatus;
import iaik.apps.trustmanager.TransientTmException;
import iaik.apps.trustmanager.TrustedKeyUsage;
import iaik.apps.trustmanager.TrustmanagerAPI;
import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.TrustmanagerPolicyException;
import iaik.apps.trustmanager.ValidityStatus;
import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.api.Trustmanager;
import iaik.apps.trustmanager.cert.CertStore;
import iaik.apps.trustmanager.crl.CRLManager;
import iaik.apps.trustmanager.net.ReceiveCRLoverHTTP;
import iaik.apps.trustmanager.net.ReceiveCRLoverLDAP;
import iaik.apps.trustmanager.time.TrustedTime;
import iaik.apps.trustmanager.trust.PurposeProperties;
import iaik.apps.trustmanager.trust.TrustProperties;
import iaik.apps.trustmanager.trust.TrustRecord;
import iaik.apps.trustmanager.trust.TrustStore;
import iaik.apps.trustmanager.utils.Integrity;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.structures.Name;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TrustManagerWrapper {
    private static final boolean a = false;
    private String b = null;
    private String c;
    private char[] d;
    private boolean[] e = null;
    private TrustmanagerAPI f;
    private e g;

    public TrustManagerWrapper(String string, char[] cArray) {
        this.c = string;
        this.d = cArray;
        this.a();
    }

    TrustManagerWrapper(String string, char[] cArray, int n) {
        this.c = string;
        this.d = cArray;
        try {
            this.f = new TrustmanagerAPI();
            this.f.init();
            TrustedTime.init("", new X509Certificate());
            Trustmanager.initCRLManager();
        }
        catch (Exception exception) {
            this.b = exception.getMessage();
        }
    }

    public TrustManagerWrapper(String string) {
        try {
            this.f = new TrustmanagerAPI();
            TrustedTime.init("", new X509Certificate());
            TrustEnv.initialize(string);
            Trustmanager.initCRLManager();
        }
        catch (Exception exception) {
            this.b = exception.getMessage();
        }
    }

    public String getErrorMessage() {
        return this.b;
    }

    private void a() {
        try {
            this.b();
        }
        catch (Exception exception) {
            this.b = exception.getMessage();
        }
    }

    private void b() throws RepositoryException {
        this.f = new TrustmanagerAPI();
        try {
            this.f.load(this.c, this.d);
        }
        catch (IOException iOException) {
            throw new RepositoryException(TrustManagerWrapper.a("6\u0005\u0016e}\u0016W\u0016on\u0017\u001e\nm/'\u0005\u0011y{>\u0016\nkh\u0016\u0005DLf\u001f\u0012\u0017"));
        }
        catch (TrustmanagerPolicyException trustmanagerPolicyException) {
            throw new RepositoryException(TrustManagerWrapper.a("$\u0005\u000bdhS'\u0005y|\u0004\u0018\u0016n"));
        }
        catch (TrustmanagerException trustmanagerException) {
            throw new RepositoryException(TrustManagerWrapper.a("$\u0005\u000bdhS'\u0005y|\u0004\u0018\u0016n"));
        }
    }

    public void addCertificate(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            return;
        }
        Trustmanager.putCertificate(x509Certificate);
    }

    public void addCertificateWithStandardPolicy(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            return;
        }
        Trustmanager.putCertificate(x509Certificate);
        TrustRecord trustRecord = TrustStore.getTrustRecord(x509Certificate);
        TrustProperties trustProperties = trustRecord.getTrustProperties();
        if (TrustmanagerUtils.isRootCA(x509Certificate)) {
            trustProperties.setAlwaysGetLatestRevInfo(false);
            trustProperties.setRevVerification(false);
            trustProperties.setRevVerificationIssuedCerts(true);
            this.setTrustKeyUsageForCA(trustRecord);
            trustProperties.setTrusted();
        } else if (TrustmanagerUtils.isCA(x509Certificate)) {
            trustProperties.setAlwaysGetLatestRevInfo(true);
            trustProperties.setRevVerification(true);
            trustProperties.setRevVerificationIssuedCerts(true);
            this.setTrustKeyUsageForCA(trustRecord);
            trustProperties.setTrusted();
        } else {
            trustProperties.setAlwaysGetLatestRevInfo(true);
            trustProperties.setRevVerification(true);
            trustProperties.setNeutral();
        }
        Trustmanager.putTrustRecord(trustRecord);
    }

    public void addFullyTrustedCertificate(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            return;
        }
        Trustmanager.putCertificate(x509Certificate);
        TrustRecord trustRecord = TrustStore.getTrustRecord(x509Certificate);
        TrustProperties trustProperties = trustRecord.getTrustProperties();
        trustProperties.setAlwaysGetLatestRevInfo(false);
        trustProperties.setRevVerification(false);
        trustProperties.setRevVerificationIssuedCerts(true);
        this.setTrustKeyUsageForCA(trustRecord);
        trustProperties.setTrusted();
        Trustmanager.putTrustRecord(trustRecord);
    }

    public void addCertificateNoCRL(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            return;
        }
        Trustmanager.putCertificate(x509Certificate);
        TrustRecord trustRecord = TrustStore.getTrustRecord(x509Certificate);
        TrustProperties trustProperties = trustRecord.getTrustProperties();
        trustProperties.setAlwaysGetLatestRevInfo(false);
        trustProperties.setRevVerification(false);
        if (TrustmanagerUtils.isCA(x509Certificate) || TrustmanagerUtils.isRootCA(x509Certificate)) {
            trustProperties.setRevVerificationIssuedCerts(false);
            this.setTrustKeyUsageForCA(trustRecord);
            trustProperties.setTrusted();
        } else {
            trustProperties.setNeutral();
        }
        Trustmanager.putTrustRecord(trustRecord);
    }

    public void setTrustKeyUsageForCA(TrustRecord trustRecord) {
        PurposeProperties purposeProperties = new PurposeProperties();
        purposeProperties.setDigitalSignature();
        purposeProperties.setNonRepudiation();
        purposeProperties.setEMailProtection();
        purposeProperties.setKeyEncipherment();
        purposeProperties.setDataEncipherment();
        purposeProperties.setKeyAgreement();
        purposeProperties.setEncipherOnly();
        purposeProperties.setDecipherOnly();
        purposeProperties.setCodeSigning();
        purposeProperties.setWebServerAuthen();
        purposeProperties.setTimeStamping();
        purposeProperties.setWebClientAuthen();
        purposeProperties.setKeyCertSign();
        purposeProperties.setCRLSign();
        trustRecord.setPurposeProperties(purposeProperties);
    }

    public void addCertificates(X509Certificate[] x509CertificateArray) throws RepositoryException {
        if (x509CertificateArray == null) {
            return;
        }
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            try {
                this.addCertificate(x509CertificateArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new RepositoryException(String.valueOf(String.valueOf(TrustManagerWrapper.a("\u0016\u0005\u0016e}\u0016W\noc\u001fP\rd|\u0016\u0005\rgj\u001d\u0003\u000b*k\u0016\u001bD")).concat(String.valueOf(i))).concat(String.valueOf(TrustManagerWrapper.a("S\u0014\u0001x{\u001a\u0011\rin\u0007\u0018"))));
            }
        }
    }

    public void downloadCrlOverHttp(String string) throws RepositoryException {
        try {
            ReceiveCRLoverHTTP receiveCRLoverHTTP = new ReceiveCRLoverHTTP(string);
            receiveCRLoverHTTP.go();
            while (!receiveCRLoverHTTP.done()) {
                System.out.println(receiveCRLoverHTTP.getMessage());
                System.out.println(receiveCRLoverHTTP.getLengthOfTask());
                System.out.println(receiveCRLoverHTTP.getCurrent());
                Thread.sleep(200L);
            }
            X509CRL x509CRL = receiveCRLoverHTTP.getCRL();
            if (x509CRL == null) {
                System.out.println(receiveCRLoverHTTP.getMalformedURLExceptionMessage());
                System.out.println(receiveCRLoverHTTP.getCRLExceptionMessage());
                throw new RepositoryException(String.valueOf(String.valueOf(String.valueOf(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+")).concat(String.valueOf(receiveCRLoverHTTP.getMalformedURLExceptionMessage()))).concat(String.valueOf(" "))).concat(String.valueOf(receiveCRLoverHTTP.getCRLExceptionMessage())));
            }
            this.addCRL(x509CRL);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+")).concat(String.valueOf(exception)));
            throw new RepositoryException(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+"));
        }
    }

    public void downloadCrlOverLdap(String string, String string2) throws RepositoryException {
        try {
            ReceiveCRLoverLDAP receiveCRLoverLDAP = new ReceiveCRLoverLDAP(string, string2);
            receiveCRLoverLDAP.go();
            while (!receiveCRLoverLDAP.done()) {
                System.out.println(TrustManagerWrapper.a("$\u0016\r~"));
                Thread.sleep(200L);
            }
            X509CRL x509CRL = receiveCRLoverLDAP.getCRL();
            if (x509CRL == null) {
                System.out.println(receiveCRLoverLDAP.getErrorMessage());
                throw new RepositoryException(String.valueOf(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+")).concat(String.valueOf(receiveCRLoverLDAP.getErrorMessage())));
            }
            this.addCRL(x509CRL);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+")).concat(String.valueOf(exception)));
            throw new RepositoryException(TrustManagerWrapper.a("0%(*k\u001c\u0000\nf`\u0012\u0013Do}\u0001\u0018\u0016+"));
        }
    }

    public void addCRL(X509CRL x509CRL) {
        if (x509CRL == null) {
            return;
        }
        try {
            this.f.putCRL(x509CRL);
        }
        catch (IOException iOException) {
            this.a(iOException);
        }
    }

    public void addCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null) {
            return;
        }
        for (int i = 0; i < x509CRLArray.length; ++i) {
            this.addCRL(x509CRLArray[i]);
        }
    }

    public X509Certificate[] getCertificates(String string) {
        try {
            X509Certificate[] x509CertificateArray = this.f.getCertificates(string);
            return x509CertificateArray;
        }
        catch (TransientTmException transientTmException) {
            this.a(transientTmException);
            X509Certificate[] x509CertificateArray = null;
            return x509CertificateArray;
        }
    }

    public X509Certificate[] getCertificates(Name name) {
        try {
            X509Certificate[] x509CertificateArray = this.f.getCertificates(name);
            return x509CertificateArray;
        }
        catch (TransientTmException transientTmException) {
            this.a(transientTmException);
            X509Certificate[] x509CertificateArray = null;
            return x509CertificateArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public X509Certificate[] getEncyptionCertificatesAndEnv() throws RepositoryException {
        Object[] objectArray;
        block19: {
            int n;
            boolean[] blArray;
            Object object;
            Vector<Object> vector;
            int n2;
            block20: {
                Vector<Boolean> vector2;
                block18: {
                    int n3;
                    Vector<Boolean> vector3;
                    block8: {
                        n2 = RepositoryException.c;
                        vector = new Vector<Object>();
                        vector3 = new Vector<Boolean>();
                        try {
                            objectArray = this.f.getCertificates();
                            object = objectArray.elements();
                            while (object.hasMoreElements()) {
                                block11: {
                                    Vector<Object> vector4;
                                    block16: {
                                        block17: {
                                            boolean bl;
                                            block14: {
                                                X509Certificate x509Certificate;
                                                block15: {
                                                    boolean[] blArray2;
                                                    block13: {
                                                        X509Certificate x509Certificate2;
                                                        block12: {
                                                            boolean bl2;
                                                            block10: {
                                                                x509Certificate = (X509Certificate)object.nextElement();
                                                                bl2 = TrustmanagerUtils.isRootCA(x509Certificate);
                                                                if (n2 != 0) break block10;
                                                                if (n2 != 0) break block8;
                                                                if (bl2) break block11;
                                                                x509Certificate2 = x509Certificate;
                                                                if (n2 != 0) break block12;
                                                                bl2 = TrustmanagerUtils.isCA(x509Certificate2);
                                                            }
                                                            if (bl2) break block11;
                                                            x509Certificate2 = x509Certificate;
                                                        }
                                                        blArray2 = blArray = x509Certificate2.getKeyUsage();
                                                        if (n2 != 0) break block13;
                                                        if (blArray2 == null) break block11;
                                                        blArray2 = blArray;
                                                    }
                                                    bl = blArray2[2];
                                                    if (n2 != 0) break block14;
                                                    if (bl) break block15;
                                                    bl = blArray[3];
                                                    if (n2 != 0) break block14;
                                                    if (!bl) break block11;
                                                }
                                                vector4 = vector;
                                                if (n2 != 0) break block16;
                                                vector4.addElement(x509Certificate);
                                                bl = this.f.isTrusted(x509Certificate);
                                            }
                                            if (!bl) break block17;
                                            System.out.println(TrustManagerWrapper.a("\u0016\u0019\u00127{\u0001\u0002\u0001"));
                                            vector3.addElement(new Boolean(true));
                                            if (n2 == 0) break block11;
                                        }
                                        vector4 = vector3;
                                    }
                                    vector4.addElement(new Boolean(false));
                                }
                                if (n2 == 0) continue;
                                break;
                            }
                        }
                        catch (TransientTmException transientTmException) {
                            System.out.println(String.valueOf(TrustManagerWrapper.a("6\u000f\u0007o\u007f\u0007\u001e\u000bd5S")).concat(String.valueOf(transientTmException.getMessage())));
                            throw new RepositoryException(transientTmException.getMessage());
                        }
                        n3 = vector.size();
                    }
                    objectArray = new X509Certificate[n3];
                    vector.copyInto(objectArray);
                    System.out.println(String.valueOf(TrustManagerWrapper.a("\u00052Jyf\t\u0012L#2")).concat(String.valueOf(vector3.size())));
                    vector2 = vector3;
                    if (n2 != 0) break block18;
                    if (vector2 == null) break block19;
                    vector2 = vector3;
                }
                n = vector2.size();
                if (n2 != 0) break block20;
                if (n == 0) break block19;
                System.out.println(TrustManagerWrapper.a("\u00052Jln\u0010\u0014\r3`"));
                n = vector.size();
            }
            blArray = new boolean[n];
            for (int i = 0; i < vector.size(); ++i) {
                object = (Boolean)vector.elementAt(i);
                blArray[i] = (Boolean)object;
                System.out.println(String.valueOf(String.valueOf(String.valueOf(TrustManagerWrapper.a("\u00052")).concat(String.valueOf(i))).concat(String.valueOf("="))).concat(String.valueOf(blArray[i])));
                if (n2 != 0) return objectArray;
                if (n2 == 0) continue;
            }
            this.e = blArray;
            return objectArray;
        }
        this.e = null;
        return objectArray;
    }

    public boolean[] getCertificatesEnv() {
        return this.e;
    }

    public X509Certificate[] getEncyptionCertificates() throws RepositoryException {
        Object[] objectArray;
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        try {
            objectArray = this.f.getCertificates();
            Enumeration enumeration = objectArray.elements();
            while (enumeration.hasMoreElements()) {
                boolean[] blArray;
                X509Certificate x509Certificate = (X509Certificate)enumeration.nextElement();
                if (TrustmanagerUtils.isRootCA(x509Certificate) || TrustmanagerUtils.isCA(x509Certificate) || (blArray = x509Certificate.getKeyUsage()) == null || !blArray[2] && !blArray[3]) continue;
                vector.addElement(x509Certificate);
            }
        }
        catch (TransientTmException transientTmException) {
            System.out.println(String.valueOf(TrustManagerWrapper.a("6\u000f\u0007o\u007f\u0007\u001e\u000bd5S")).concat(String.valueOf(transientTmException.getMessage())));
            throw new RepositoryException(transientTmException.getMessage());
        }
        objectArray = new X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean[] getEncyptionCertificatesEnv() throws RepositoryException {
        Object object;
        Object object2;
        Vector<Boolean> vector = new Vector<Boolean>();
        try {
            object2 = this.f.getCertificates();
            Enumeration enumeration = ((Hashtable)object2).elements();
            while (enumeration.hasMoreElements()) {
                X509Certificate x509Certificate = (X509Certificate)enumeration.nextElement();
                object = x509Certificate.getKeyUsage();
                if (object == null || !object[2] && !object[3]) continue;
                if (this.f.isTrusted(x509Certificate)) {
                    vector.addElement(new Boolean(true));
                    continue;
                }
                vector.addElement(new Boolean(false));
            }
        }
        catch (TransientTmException transientTmException) {
            throw new RepositoryException(transientTmException.getMessage());
        }
        if (vector != null && vector.size() != 0) {
            object2 = new boolean[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                object = (Boolean)vector.elementAt(i);
                object2[i] = object.booleanValue();
            }
            return object2;
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(X509Certificate x509Certificate) throws RepositoryException {
        if (x509Certificate == null) {
            return null;
        }
        try {
            X509Certificate[] x509CertificateArray = this.f.getCertificateChain(x509Certificate);
            return x509CertificateArray;
        }
        catch (TransientTmException transientTmException) {
            throw new RepositoryException(transientTmException.getMessage());
        }
    }

    private void a(Throwable throwable) {
        System.err.println(TrustManagerWrapper.a("'\u0005\u0011y{>\u0016\nkh\u0016\u0005Dow\u0010\u0012\u0014~f\u001c\u0019^"));
        throwable.printStackTrace(System.err);
    }

    public boolean isTrustedCert(X509Certificate x509Certificate) {
        try {
            if (x509Certificate == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.f.isTrusted(x509Certificate)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.a(exception);
            boolean bl = false;
            return bl;
        }
    }

    public boolean isTrust(X509Certificate x509Certificate) {
        try {
            if (x509Certificate == null) {
                boolean bl = false;
                return bl;
            }
            int n = Trustmanager.getTrustStatus(x509Certificate);
            if (n == 3 || n == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            this.a(exception);
            boolean bl = false;
            return bl;
        }
    }

    public boolean isValidCert(X509Certificate x509Certificate) {
        try {
            if (x509Certificate == null) {
                boolean bl = false;
                return bl;
            }
            int n = this.f.getValidityStatus(x509Certificate, null);
            if (n != ValidityStatus.VALID && n != ValidityStatus.EXPIRING_SOON) {
                boolean bl = false;
                return bl;
            }
            RevocationStatus revocationStatus = this.f.getRevocationStatus(x509Certificate, null);
            if (revocationStatus.status != 1 && revocationStatus.status != 2) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.a(exception);
            boolean bl = false;
            return bl;
        }
    }

    public RevocationStatus getRevocationStatus(X509Certificate x509Certificate) {
        try {
            RevocationStatus revocationStatus;
            if (x509Certificate == null) {
                RevocationStatus revocationStatus2 = null;
                return revocationStatus2;
            }
            RevocationStatus revocationStatus3 = revocationStatus = this.f.getRevocationStatus(x509Certificate, null);
            return revocationStatus3;
        }
        catch (Exception exception) {
            this.a(exception);
            RevocationStatus revocationStatus = null;
            return revocationStatus;
        }
    }

    public boolean isValidTrustedCert(X509Certificate x509Certificate) {
        return this.isTrustedCert(x509Certificate) && this.isValidCert(x509Certificate);
    }

    private TrustedKeyUsage a(X509Certificate x509Certificate) {
        try {
            if (x509Certificate == null) {
                TrustedKeyUsage trustedKeyUsage = null;
                return trustedKeyUsage;
            }
            TrustedKeyUsage trustedKeyUsage = this.f.getTrustedKeyUsage(x509Certificate);
            return trustedKeyUsage;
        }
        catch (TransientTmException transientTmException) {
            this.a(transientTmException);
            TrustedKeyUsage trustedKeyUsage = null;
            return trustedKeyUsage;
        }
    }

    public boolean isSignatureCert(X509Certificate x509Certificate) {
        TrustedKeyUsage trustedKeyUsage = this.a(x509Certificate);
        if (trustedKeyUsage == null) {
            return false;
        }
        return trustedKeyUsage.digitalSignature || trustedKeyUsage.nonRepudiation;
    }

    public boolean isEncryptionCert(X509Certificate x509Certificate) {
        TrustedKeyUsage trustedKeyUsage = this.a(x509Certificate);
        if (trustedKeyUsage == null) {
            return false;
        }
        return trustedKeyUsage.encipherment;
    }

    public void startAutoSave() {
        this.stopAutoSave();
        this.g = new e(this.f);
        Thread thread = new Thread(this.g);
        thread.setDaemon(true);
        thread.start();
    }

    public void stopAutoSave() {
        if (this.g != null) {
            this.g.a(false);
            this.g = null;
        }
    }

    public void save() throws RepositoryException {
        if (this.f != null && this.f.isModified()) {
            try {
                this.f.store();
            }
            catch (IOException iOException) {
                System.err.println(TrustManagerWrapper.a("$66DF=0^*J\u0001\u0005\u000bx/\u0000\u0016\u0012ca\u0014W\u0010xz\u0000\u0003\tka\u0012\u0010\u0001x5"));
                iOException.printStackTrace(System.err);
                throw new RepositoryException(TrustManagerWrapper.a("6\u0005\u0016e}S\u0004\u0005|f\u001d\u0010D~}\u0006\u0004\u0010gn\u001d\u0016\u0003o}"));
            }
        }
    }

    public static TrustManagerWrapper makeEmptyFiles(String string, char[] cArray) {
        try {
            Integrity.setPassword(cArray);
            TrustEnv.initialize(string);
            CertStore certStore = new CertStore();
            TrustStore trustStore = new TrustStore();
            CRLManager cRLManager = new CRLManager();
            Trustmanager trustmanager = new Trustmanager();
            Trustmanager.store();
            TrustManagerWrapper trustManagerWrapper = new TrustManagerWrapper(string, cArray, 0);
            return trustManagerWrapper;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TrustManagerWrapper trustManagerWrapper = null;
            return trustManagerWrapper;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 115;
                        break;
                    }
                    case 1: {
                        n4 = 119;
                        break;
                    }
                    case 2: {
                        n4 = 100;
                        break;
                    }
                    case 3: {
                        n4 = 10;
                        break;
                    }
                    default: {
                        n4 = 15;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

