/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.repository;

import cybertrust2.CTException;
import cybertrust2.repository.RepositoryConstants;
import cybertrust2.repository.RepositoryException;
import cybertrust2.repository.RepositoryProperties;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509Extensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Random;

public abstract class Repository
implements RepositoryConstants {
    private static boolean a = false;
    public String ENCRYPTION_ALIAS;
    public String PENDING_ENCRYPTION_ALIAS;
    public String SIGNATURE_ALIAS;
    public String PENDING_SIGNATURE_ALIAS;
    public String CA_ALIAS;
    private String b;
    private int c;
    private String d;
    private int e;
    private boolean[] f;
    private boolean g;
    private boolean[] h;
    private boolean i;
    private boolean[] j;
    private boolean k;
    static Name l = new Name();

    Repository(RepositoryProperties repositoryProperties) throws RepositoryException {
        this.a(repositoryProperties);
    }

    Repository(InputStream inputStream) throws RepositoryException {
        try {
            RepositoryProperties repositoryProperties = new RepositoryProperties();
            repositoryProperties.load(inputStream);
            this.a(repositoryProperties);
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw new RepositoryException(Repository.d("4\u0012\u001clRQ\u0012\u000bbD\u0018\u000e\t#S\u0014\u0014\u001ajN\u0016\u0013"));
        }
    }

    void a(RepositoryProperties repositoryProperties) throws RepositoryException {
        int n = RepositoryException.c;
        this.ENCRYPTION_ALIAS = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u000bmC\u0003\u0019\u001ewI\u001e\u000e@`U\u0003\u0012\u000bmT"));
        if (this.ENCRYPTION_ALIAS == null || this.ENCRYPTION_ALIAS.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u000bmC\u0003\u0019\u001ewI\u001e\u000e@`U\u0003\u0012\u000bmT")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.PENDING_ENCRYPTION_ALIAS = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u000bmC\u0003\u0019\u001ewI\u001e\u000e@sE\u001f\u0004\u0007mG"));
        if (this.PENDING_ENCRYPTION_ALIAS == null || this.PENDING_ENCRYPTION_ALIAS.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u000bmC\u0003\u0019\u001ewI\u001e\u000e@sE\u001f\u0004\u0007mG")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.SIGNATURE_ALIAS = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u001djG\u001f\u0001\u001avR\u0014N\rvR\u0003\u0005\u0000w"));
        if (this.SIGNATURE_ALIAS == null || this.SIGNATURE_ALIAS.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u001djG\u001f\u0001\u001avR\u0014N\rvR\u0003\u0005\u0000w")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.PENDING_SIGNATURE_ALIAS = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u001djG\u001f\u0001\u001avR\u0014N\u001efN\u0015\t\u0000d"));
        if (this.PENDING_SIGNATURE_ALIAS == null || this.PENDING_SIGNATURE_ALIAS.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\u001djG\u001f\u0001\u001avR\u0014N\u001efN\u0015\t\u0000d")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.CA_ALIAS = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\rb"));
        if (this.CA_ALIAS == null || this.CA_ALIAS.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0001\u0002jA\u0002N\rb")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.b = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u000b\u000bz\u000e\u0005\u0019\u001ef"));
        if (this.b == null || this.b.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u000b\u000bz\u000e\u0005\u0019\u001ef")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.c = repositoryProperties.getIntProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u000b\u000bz\u000e\u001d\u0005\u0000dT\u0019"), 0);
        if (this.c == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u000b\u000bz\u000e\u001d\u0005\u0000dT\u0019")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.d = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u0005fY_\u0014\u0017sE"));
        if (this.d == null || this.d.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u0005fY_\u0014\u0017sE")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.e = repositoryProperties.getIntProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u0005fY_\f\u000bmG\u0005\b"), 0);
        if (this.e == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u0005fY_\f\u000bmG\u0005\b")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        String string = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u001bpA\u0016\u0005"));
        if (string == null || string.length() == 0) {
            throw new RepositoryException(String.valueOf(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u0005fY_\f\u000bmG\u0005\b")).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.h = this.a(string);
        this.i = repositoryProperties.getBooleanProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0005\u0000`R\b\u0010\u001ajO\u001fN\u001bpA\u0016\u0005@`H\u0014\u0003\u0005bL\u001d"), false);
        string = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u0015\u001dbG\u0014"));
        if (string == null || string.length() == 0) {
            throw new RepositoryException(String.valueOf(this.f).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.f = this.a(string);
        this.g = repositoryProperties.getBooleanProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0013\u0007dN\u0010\u0014\u001bqE_\u0015\u001dbG\u0014N\rkE\u0012\u000b\u000foL"), false);
        string = repositoryProperties.getProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0003\u000f-U\u0002\u0001\tf"));
        if (string == null || string.length() == 0) {
            throw new RepositoryException(String.valueOf(this.j).concat(String.valueOf(Repository.d("Q\u000e\u0001w\u0000\u0002\u0005\u001a/\u0000\u0012\b\u000b`KQ\u0012\u000bsO\u0002\t\u001alR\b@\rlN\u0017\t\tvR\u0010\u0014\u0007lN"))));
        }
        this.j = this.a(string);
        this.k = repositoryProperties.getBooleanProperty(Repository.d("\u0003\u0005\u001elS\u0018\u0014\u0001qY_\u0003\u000f-U\u0002\u0001\tf\u000e\u0012\b\u000b`K\u0010\f\u0002"), false);
        if (n != 0) {
            CTException.b = !CTException.b;
        }
    }

    private boolean[] a(String string) {
        boolean[] blArray = new boolean[9];
        for (int n = 0; n < 9; n = (int)((short)(n + 1))) {
            try {
                if (Character.getNumericValue(string.charAt(n)) == 1) {
                    blArray[n] = true;
                    continue;
                }
                blArray[n] = false;
                continue;
            }
            catch (Throwable throwable) {
                blArray[n] = false;
            }
        }
        return blArray;
    }

    public void importPKCS12(PKCS12 pKCS12, String string, byte[] byArray) throws RepositoryException {
        try {
            pKCS12.decrypt(string.toCharArray());
            PrivateKey privateKey = pKCS12.getKeyBag().getPrivateKey();
            X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])pKCS12.getCertificateBags());
            x509CertificateArray = cybertrust2.util.Util.sortCertificateChain(x509CertificateArray);
            this.storePrivateKey(byArray, privateKey, x509CertificateArray);
        }
        catch (PKCSException pKCSException) {
            this.a((Exception)((Object)pKCSException));
            throw new RepositoryException(pKCSException.getMessage());
        }
        catch (CTException cTException) {
            this.a(cTException);
            throw new RepositoryException(Repository.d("&\u0012\u0001mGQ\u0003\u000bqT\u0018\u0006\u0007`A\u0005\u0005\u001d#C\u0019\u0001\u0007m"));
        }
    }

    public void importPKCS12(InputStream inputStream, String string, byte[] byArray) throws RepositoryException {
        try {
            PKCS12 pKCS12 = new PKCS12(inputStream);
            pKCS12.decrypt(string.toCharArray());
            PrivateKey privateKey = pKCS12.getKeyBag().getPrivateKey();
            X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])pKCS12.getCertificateBags());
            x509CertificateArray = cybertrust2.util.Util.sortCertificateChain(x509CertificateArray);
            this.storePrivateKey(byArray, privateKey, x509CertificateArray);
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw new RepositoryException(iOException.getMessage());
        }
        catch (PKCSException pKCSException) {
            this.a((Exception)((Object)pKCSException));
            throw new RepositoryException(pKCSException.getMessage());
        }
        catch (CTException cTException) {
            this.a(cTException);
            throw new RepositoryException(Repository.d("&\u0012\u0001mGQ\u0003\u000bqT\u0018\u0006\u0007`A\u0005\u0005\u001d#C\u0019\u0001\u0007m"));
        }
    }

    public PKCS12 exportPKCS12(byte[] byArray) throws RepositoryException {
        try {
            PKCS12 pKCS12;
            PrivateKey privateKey = this.getPrivateKey(byArray);
            X509Certificate[] x509CertificateArray = this.getX509CertificateChain(byArray);
            try {
                x509CertificateArray = cybertrust2.util.Util.sortCertificateChain(x509CertificateArray);
            }
            catch (CTException cTException) {
                // empty catch block
            }
            byte[] byArray2 = byArray;
            String string = x509CertificateArray[0].getSubjectDN().toString();
            KeyBag keyBag = new KeyBag(privateKey, new String(byArray), byArray2);
            CertificateBag[] certificateBagArray = new CertificateBag[x509CertificateArray.length];
            certificateBagArray[0] = new CertificateBag(x509CertificateArray[0], string, byArray2);
            for (int i = 1; i < x509CertificateArray.length; ++i) {
                certificateBagArray[i] = new CertificateBag(x509CertificateArray[i]);
            }
            PKCS12 pKCS122 = pKCS12 = new PKCS12(keyBag, certificateBagArray);
            return pKCS122;
        }
        catch (PKCSException pKCSException) {
            this.a((Exception)((Object)pKCSException));
            throw new RepositoryException(pKCSException.getMessage());
        }
    }

    public void exportPKCS12(byte[] byArray, OutputStream outputStream, String string) throws RepositoryException {
        int n = RepositoryException.c;
        try {
            PrivateKey privateKey = this.getPrivateKey(byArray);
            X509Certificate[] x509CertificateArray = this.getX509CertificateChain(byArray);
            try {
                x509CertificateArray = cybertrust2.util.Util.sortCertificateChain(x509CertificateArray);
            }
            catch (CTException cTException) {
                // empty catch block
            }
            byte[] byArray2 = byArray;
            String string2 = x509CertificateArray[0].getSubjectDN().toString();
            KeyBag keyBag = new KeyBag(privateKey, new String(byArray), byArray2);
            CertificateBag[] certificateBagArray = new CertificateBag[x509CertificateArray.length];
            certificateBagArray[0] = new CertificateBag(x509CertificateArray[0], string2, byArray2);
            for (int i = 1; i < x509CertificateArray.length; ++i) {
                certificateBagArray[i] = new CertificateBag(x509CertificateArray[i]);
                if (n == 0) continue;
            }
            PKCS12 pKCS12 = new PKCS12(keyBag, certificateBagArray);
            pKCS12.encrypt(string.toCharArray());
            pKCS12.writeTo(outputStream);
        }
        catch (IOException iOException) {
            this.a(iOException);
            throw new RepositoryException(iOException.getMessage());
        }
        catch (PKCSException pKCSException) {
            this.a((Exception)((Object)pKCSException));
            throw new RepositoryException(pKCSException.getMessage());
        }
        if (CTException.b) {
            RepositoryException.c = ++n;
        }
    }

    public boolean isValidForSignature(boolean[] blArray) {
        return this.a(blArray, this.f, this.g);
    }

    public boolean isValidForEncryption(boolean[] blArray) {
        return this.a(blArray, this.h, this.i);
    }

    public boolean isValidCA(boolean[] blArray) {
        return this.a(blArray, this.j, this.k);
    }

    private boolean a(boolean[] blArray, boolean[] blArray2, boolean bl) {
        if (blArray == null && bl) {
            return false;
        }
        if (blArray == null && !bl) {
            boolean[] blArray3 = new boolean[]{false, false, false, false, false, false, false, false, false};
            blArray = blArray3;
        }
        boolean bl2 = true;
        for (int n = 0; n < 9; n = (int)((short)(n + 1))) {
            bl2 = bl ? bl2 && blArray2[n] == blArray[n] : bl2 && (blArray2[n] && blArray[n]) == blArray2[n];
        }
        return bl2;
    }

    public byte[] findAlias(Name name, BigInteger bigInteger) {
        try {
            Enumeration enumeration = this.aliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray = (byte[])enumeration.nextElement();
                Certificate certificate = this.getCertificate(byArray);
                if (certificate == null) continue;
                try {
                    X509Certificate x509Certificate = new X509Certificate(certificate.getEncoded());
                    if (!x509Certificate.getIssuerDN().equals(name) || !x509Certificate.getSerialNumber().equals(bigInteger)) continue;
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                catch (CertificateException certificateException) {
                }
            }
        }
        catch (RepositoryException repositoryException) {
            this.a(repositoryException);
            byte[] byArray = null;
            return byArray;
        }
        return null;
    }

    public byte[] findAlias(PublicKey publicKey) {
        try {
            Enumeration enumeration = this.aliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray = (byte[])enumeration.nextElement();
                try {
                    PublicKey publicKey2 = this.getPublicKey(byArray);
                    if (publicKey2 == null || !publicKey2.equals(publicKey)) continue;
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        }
        catch (RepositoryException repositoryException) {
            this.a(repositoryException);
            byte[] byArray = null;
            return byArray;
        }
        return null;
    }

    private int b(String string) throws RepositoryException {
        int n = 0;
        try {
            Enumeration enumeration = this.aliases();
            while (enumeration.hasMoreElements()) {
                byte[] byArray = (byte[])enumeration.nextElement();
                String string2 = new String(byArray);
                if (!string2.startsWith(string)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(String.valueOf(Repository.d("!\u0012\u0001aL\u0014\r\u001d#A\u0012\u0003\u000bpS\u0018\u000e\t#R\u0014\u0010\u0001pI\u0005\u000f\u001cz\fQj")).concat(String.valueOf(exception.getMessage())));
        }
        return n;
    }

    private byte[] a(int n) throws RepositoryException {
        String string;
        int n2 = 0;
        switch (n) {
            case 1: {
                string = this.PENDING_SIGNATURE_ALIAS;
                n2 = this.b(this.PENDING_SIGNATURE_ALIAS);
                break;
            }
            case 0: {
                string = this.PENDING_ENCRYPTION_ALIAS;
                n2 = this.b(this.PENDING_ENCRYPTION_ALIAS);
                break;
            }
            default: {
                throw new RepositoryException(Repository.d("8\u000e\u0018bL\u0018\u0004NHE\b\u0010\u000fjRQ\u0015\u001dbG\u0014ZNmE\u0018\u0014\u0006fRQ3'Dn04;QeQ\u000e\u0001q\u00004.-Qy!4'Ln_"));
            }
        }
        return String.valueOf(string).concat(String.valueOf(n2)).getBytes();
    }

    private byte[] b(int n) throws RepositoryException {
        String string;
        int n2 = 0;
        switch (n) {
            case 1: {
                string = this.SIGNATURE_ALIAS;
                n2 = this.b(this.SIGNATURE_ALIAS);
                break;
            }
            case 0: {
                string = this.ENCRYPTION_ALIAS;
                n2 = this.b(this.ENCRYPTION_ALIAS);
                break;
            }
            default: {
                throw new RepositoryException(Repository.d("8\u000e\u0018bL\u0018\u0004NHE\b\u0010\u000fjRQ\u0015\u001dbG\u0014ZNmE\u0018\u0014\u0006fRQ3'Dn04;QeQ\u000e\u0001q\u00004.-Qy!4'Ln_"));
            }
        }
        return String.valueOf(string).concat(String.valueOf(n2)).getBytes();
    }

    public X509Certificate getEncryptionCertificate(byte[] byArray) throws RepositoryException {
        X509Certificate x509Certificate = this.getX509Certificate(byArray);
        if (x509Certificate == null) {
            return null;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!this.isValidForEncryption(blArray)) {
            return null;
        }
        return x509Certificate;
    }

    public X509Certificate getSignatureCertificate(byte[] byArray) throws RepositoryException {
        X509Certificate x509Certificate = this.getX509Certificate(byArray);
        if (x509Certificate == null) {
            return null;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!this.isValidForSignature(blArray)) {
            return null;
        }
        return x509Certificate;
    }

    public X509Certificate getEncryptionCertificate(Name name, BigInteger bigInteger) throws RepositoryException {
        X509Certificate x509Certificate = this.getX509Certificate(name, bigInteger);
        if (x509Certificate == null) {
            return null;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!this.isValidForEncryption(blArray)) {
            return null;
        }
        return x509Certificate;
    }

    public X509Certificate getSignatureCertificate(Name name, BigInteger bigInteger) throws RepositoryException {
        X509Certificate x509Certificate = this.getX509Certificate(name, bigInteger);
        if (x509Certificate == null) {
            return null;
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!this.isValidForSignature(blArray)) {
            return null;
        }
        return x509Certificate;
    }

    public X509Certificate getCACertificate() throws RepositoryException {
        try {
            Certificate certificate = this.getCertificate(this.CA_ALIAS.getBytes());
            if (certificate == null) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = new X509Certificate(certificate.getEncoded());
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (!this.isValidCA(blArray)) {
                X509Certificate x509Certificate2 = null;
                return x509Certificate2;
            }
            X509Certificate x509Certificate3 = x509Certificate;
            return x509Certificate3;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void storeCACertificate(X509Certificate x509Certificate) throws RepositoryException {
        try {
            this.storeCertificate(this.CA_ALIAS.getBytes(), x509Certificate);
        }
        catch (RepositoryException repositoryException) {
            this.a(repositoryException);
            throw new RepositoryException(String.valueOf(Repository.d("$\u000e\u000faL\u0014@\u001al\u0000\u0002\u0005\u001a#c0@\rfR\u0005\t\bjC\u0010\u0014\u000b9\u0000")).concat(String.valueOf(repositoryException.getMessage())));
        }
    }

    public X509Certificate[] getX509CertificateChain(byte[] byArray) throws RepositoryException {
        try {
            Certificate[] certificateArray = this.getCertificateChain(byArray);
            if (certificateArray == null || certificateArray.length == 0) {
                X509Certificate[] x509CertificateArray = null;
                return x509CertificateArray;
            }
            X509Certificate[] x509CertificateArray = Util.convertCertificateChain((Certificate[])certificateArray);
            try {
                x509CertificateArray = cybertrust2.util.Util.sortCertificateChain(x509CertificateArray);
            }
            catch (CTException cTException) {
                // empty catch block
            }
            if (x509CertificateArray[0].getSubjectDN().equals(l)) {
                X509Certificate[] x509CertificateArray2 = null;
                return x509CertificateArray2;
            }
            X509Certificate[] x509CertificateArray3 = x509CertificateArray;
            return x509CertificateArray3;
        }
        catch (CertificateException certificateException) {
            this.a(certificateException);
            throw new RepositoryException(certificateException.getMessage());
        }
    }

    public X509Certificate[] getX509CertificateChain(Name name, BigInteger bigInteger) throws RepositoryException {
        byte[] byArray = this.findAlias(name, bigInteger);
        if (byArray == null) {
            return null;
        }
        return this.getX509CertificateChain(byArray);
    }

    public X509Certificate getX509Certificate(byte[] byArray) throws RepositoryException {
        try {
            Certificate certificate = this.getCertificate(byArray);
            if (certificate == null) {
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            X509Certificate x509Certificate = new X509Certificate(certificate.getEncoded());
            if (x509Certificate.getSubjectDN().equals(l)) {
                X509Certificate x509Certificate2 = null;
                return x509Certificate2;
            }
            X509Certificate x509Certificate3 = x509Certificate;
            return x509Certificate3;
        }
        catch (CertificateException certificateException) {
            this.a(certificateException);
            throw new RepositoryException(certificateException.getMessage());
        }
    }

    public X509Certificate getX509Certificate(Name name, BigInteger bigInteger) throws RepositoryException {
        byte[] byArray = this.findAlias(name, bigInteger);
        if (byArray == null) {
            return null;
        }
        return this.getX509Certificate(byArray);
    }

    int c(int n) throws RepositoryException {
        switch (n) {
            case 1: {
                return this.c;
            }
            case 0: {
                return this.e;
            }
        }
        throw new RepositoryException(Repository.d("8\u000e\u0018bL\u0018\u0004NHE\b\u0010\u000fjRQ\u0015\u001dbG\u0014ZNmE\u0018\u0014\u0006fRQ3'Dn04;QeQ\u000e\u0001q\u00004.-Qy!4'Ln_"));
    }

    String d(int n) throws RepositoryException {
        switch (n) {
            case 1: {
                return this.b;
            }
            case 0: {
                return this.d;
            }
        }
        throw new RepositoryException(Repository.d("8\u000e\u0018bL\u0018\u0004NHE\b\u0010\u000fjRQ\u0015\u001dbG\u0014ZNmE\u0018\u0014\u0006fRQ3'Dn04;QeQ\u000e\u0001q\u00004.-Qy!4'Ln_"));
    }

    public PrivateKey getDecryptionKey(byte[] byArray) throws RepositoryException {
        if (this.getEncryptionCertificate(byArray) == null) {
            return null;
        }
        PrivateKey privateKey = this.getPrivateKey(byArray);
        return privateKey;
    }

    public PrivateKey getDecryptionKey(Name name, BigInteger bigInteger) throws RepositoryException {
        if (this.getEncryptionCertificate(name, bigInteger) == null) {
            return null;
        }
        PrivateKey privateKey = this.getPrivateKey(name, bigInteger);
        return privateKey;
    }

    public PrivateKey getSignatureKey(byte[] byArray) throws RepositoryException {
        if (this.getSignatureCertificate(byArray) == null) {
            return null;
        }
        PrivateKey privateKey = this.getPrivateKey(byArray);
        return privateKey;
    }

    public PrivateKey getSignatureKey(Name name, BigInteger bigInteger) throws RepositoryException {
        if (this.getSignatureCertificate(name, bigInteger) == null) {
            return null;
        }
        PrivateKey privateKey = this.getPrivateKey(name, bigInteger);
        return privateKey;
    }

    public abstract PublicKey getPublicKey(byte[] var1) throws RepositoryException;

    public abstract KeyPair getKeyPair(byte[] var1) throws RepositoryException;

    public KeyPair getKeyPair(Name name, BigInteger bigInteger) throws RepositoryException {
        PrivateKey privateKey = this.getPrivateKey(name, bigInteger);
        X509Certificate x509Certificate = this.getX509Certificate(name, bigInteger);
        if (x509Certificate == null) {
            return null;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (privateKey == null || publicKey == null) {
            return null;
        }
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return keyPair;
    }

    public PrivateKey getPrivateKey(Name name, BigInteger bigInteger) throws RepositoryException {
        byte[] byArray = this.findAlias(name, bigInteger);
        if (byArray == null) {
            return null;
        }
        return this.getPrivateKey(byArray);
    }

    public KeyPair generateKeyPair(int n) throws RepositoryException {
        byte[] byArray = this.a(n);
        String string = this.d(n);
        int n2 = this.c(n);
        KeyPair keyPair = this.generateKeyPair(byArray, string, n2);
        return keyPair;
    }

    public KeyPair generateKeyPair(byte[] byArray, String string, int n) throws RepositoryException {
        KeyPair keyPair = cybertrust2.util.Util.newKeyPair(string, n);
        this.storePrivateKey(byArray, keyPair);
        return keyPair;
    }

    public KeyPair generateRSAKeyPair(byte[] byArray, byte[] byArray2, int n) throws RepositoryException {
        KeyPair keyPair = cybertrust2.util.Util.newKeyPair(byArray2, n);
        this.storePrivateKey(byArray, keyPair);
        return keyPair;
    }

    public void updatePendingKeypair(int n, X509Certificate[] x509CertificateArray) throws RepositoryException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509CertificateArray[0].getPublicKey();
        byte[] byArray = this.findAlias((PublicKey)rSAPublicKey);
        if (byArray == null || !this.isKeyEntry(byArray)) {
            throw new RepositoryException(Repository.d("?\u000fNsR\u0018\u0016\u000fwEQ\u000b\u000bz\u0000\u0017\u000f\u001bmD"));
        }
        byte[] byArray2 = this.b(n);
        this.a(byArray, byArray2, x509CertificateArray);
    }

    public void updatePendingKeypair(byte[] byArray, X509Certificate[] x509CertificateArray) throws RepositoryException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509CertificateArray[0].getPublicKey();
        byte[] byArray2 = this.findAlias((PublicKey)rSAPublicKey);
        if (byArray2 == null || !this.isKeyEntry(byArray2)) {
            throw new RepositoryException(Repository.d("?\u000fNsR\u0018\u0016\u000fwEQ\u000b\u000bz\u0000\u0017\u000f\u001bmD"));
        }
        this.a(byArray2, byArray, x509CertificateArray);
    }

    abstract void a(byte[] var1, byte[] var2, X509Certificate[] var3) throws RepositoryException;

    public void storePrivateKey(byte[] byArray, KeyPair keyPair) throws RepositoryException {
        X509Certificate[] x509CertificateArray = new X509Certificate[1];
        try {
            x509CertificateArray[0] = this.a(keyPair, l, null);
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
        this.storePrivateKey(byArray, keyPair.getPrivate(), x509CertificateArray);
    }

    private X509Certificate a(KeyPair keyPair, Name name, X509Extensions x509Extensions) throws RepositoryException {
        int n = RepositoryException.c;
        X509Certificate x509Certificate = new X509Certificate();
        x509Certificate.setIssuerDN((Principal)name);
        x509Certificate.setSubjectDN((Principal)name);
        x509Certificate.setSerialNumber(new BigInteger(100, new Random()));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
        gregorianCalendar.add(2, 12);
        x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
        try {
            Object object;
            x509Certificate.setPublicKey(keyPair.getPublic());
            if (n == 0) {
                if (x509Extensions != null) {
                    object = x509Extensions.listExtensions();
                    while (object.hasMoreElements()) {
                        x509Certificate.addExtension((V3Extension)object.nextElement());
                        if (n == 0 || n == 0) {
                            continue;
                        }
                        break;
                    }
                } else {
                    x509Certificate.sign(AlgorithmID.sha1WithRSAEncryption, keyPair.getPrivate());
                }
            }
            object = x509Certificate;
            return object;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(String.valueOf(Repository.d("!\u0012\u0001aL\u0014\r\u001d#S\u0005\u000f\u001cjN\u0016@\u001akEQ\u0007\u000bmE\u0003\u0001\u001afDQ\u000b\u000bzP\u0010\t\u001c9\u0000{i")).concat(String.valueOf(exception.getMessage())));
        }
    }

    public abstract Enumeration aliases() throws RepositoryException;

    public abstract boolean containsAlias(byte[] var1) throws RepositoryException;

    public abstract boolean isCertificateEntry(byte[] var1) throws RepositoryException;

    abstract Certificate[] getCertificateChain(byte[] var1) throws RepositoryException;

    public abstract void storeCertificateChain(byte[] var1, X509Certificate[] var2) throws RepositoryException;

    abstract Certificate getCertificate(byte[] var1) throws RepositoryException;

    public abstract void storeCertificate(byte[] var1, X509Certificate var2) throws RepositoryException;

    public abstract void deleteCertificate(byte[] var1) throws RepositoryException;

    public abstract PrivateKey getPrivateKey(byte[] var1) throws RepositoryException;

    public abstract void storePrivateKey(byte[] var1, PrivateKey var2, X509Certificate[] var3) throws RepositoryException;

    public abstract void deletePrivateKey(byte[] var1) throws RepositoryException;

    public abstract boolean isKeyEntry(byte[] var1) throws RepositoryException;

    public abstract boolean isOpened(boolean var1);

    public abstract void open() throws RepositoryException;

    public abstract void open(String var1) throws RepositoryException;

    public abstract void close();

    public abstract void changePassword(String var1, String var2) throws RepositoryException;

    public abstract AlgorithmID getSignatureAlgorithm();

    public abstract String toString();

    public static void setDebugMode() {
        a = true;
    }

    void a(Exception exception) {
        if (a) {
            exception.printStackTrace();
        }
    }

    void c(String string) {
        if (a) {
            System.out.println(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf(Repository.d("K@")))).concat(String.valueOf(string)));
        }
    }

    static {
        l.addRDN(ObjectID.country, (Object)Repository.d("84"));
        l.addRDN(ObjectID.locality, (Object)Repository.d("#\u000f\u0003f"));
        l.addRDN(ObjectID.organization, (Object)Repository.d("!\u0001\tfe\u0004\u0012\u0001sA"));
        l.addRDN(ObjectID.organizationalUnit, (Object)Repository.d("84=fC\u0004\u0012\u0007wY"));
        l.addRDN(ObjectID.commonName, (Object)Repository.d("\u0017\u0001\u0005fs\u0014\f\bPI\u0016\u000e\u000bgc\u0014\u0012\u001ajF\u0018\u0003\u000fwE"));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 113;
                        break;
                    }
                    case 1: {
                        n4 = 96;
                        break;
                    }
                    case 2: {
                        n4 = 110;
                        break;
                    }
                    case 3: {
                        n4 = 3;
                        break;
                    }
                    default: {
                        n4 = 32;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

