/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.repository;

import cybertrust2.CTException;
import cybertrust2.repository.Repository;
import cybertrust2.repository.RepositoryException;
import cybertrust2.repository.RepositoryProperties;
import cybertrust2.repository.b;
import cybertrust2.util.Util;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class Pkcs12Repository
extends Repository {
    private String m;
    private PKCS12 n;
    private String o = null;
    private KeyBag p;
    private CertificateBag[] q;

    public Pkcs12Repository(InputStream inputStream, String string) throws RepositoryException {
        super(inputStream);
        this.m = string;
    }

    public Pkcs12Repository(RepositoryProperties repositoryProperties, String string) throws RepositoryException {
        super(repositoryProperties);
        this.m = string;
    }

    public Enumeration aliases() throws RepositoryException {
        Vector<byte[]> vector = new Vector<byte[]>();
        if (this.p != null) {
            vector.addElement(this.p.getLocalKeyID());
        }
        return vector.elements();
    }

    public boolean containsAlias(byte[] byArray) throws RepositoryException {
        try {
            boolean bl = this.q[0].getLocalKeyID().equals(byArray) || this.p.getLocalKeyID().equals(byArray);
            return bl;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public boolean isCertificateEntry(byte[] byArray) throws RepositoryException {
        return false;
    }

    Certificate[] getCertificateChain(byte[] byArray) throws RepositoryException {
        try {
            b b2 = new b(byArray);
            b b3 = new b(this.p.getLocalKeyID());
            if (!b2.equals(b3)) {
                Certificate[] certificateArray = null;
                return certificateArray;
            }
            X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])this.q);
            X509Certificate[] x509CertificateArray2 = x509CertificateArray = Util.sortCertificateChain(x509CertificateArray);
            return x509CertificateArray2;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void storeCertificateChain(byte[] byArray, X509Certificate[] x509CertificateArray) throws RepositoryException {
        b b2 = new b(byArray);
        if (!b2.equals(this.p.getLocalKeyID())) {
            throw new RepositoryException(Pkcs12Repository.e("j4Q,\nt6\u001f)\u000fs0Lh\ru%\u001f.\fo?["));
        }
        PrivateKey privateKey = this.p.getPrivateKey();
        this.storePrivateKey(byArray, privateKey, x509CertificateArray);
    }

    Certificate getCertificate(byte[] byArray) throws RepositoryException {
        b b2 = new b(byArray);
        b b3 = new b(this.p.getLocalKeyID());
        if (!b2.equals(b3)) {
            return null;
        }
        try {
            X509Certificate x509Certificate = this.q[0].getCertificate();
            return x509Certificate;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void storeCertificate(byte[] byArray, X509Certificate x509Certificate) throws RepositoryException {
        throw new RepositoryException(Pkcs12Repository.e("W4K \f~qQ'\u0017:8R8\u000f\u007f<Z&\u0017\u007f5\u0005h\nw!P;\u0010s3S-Cn>\u001f;\u0017u#Zh\u0002:\"V&\u0004v4\u001f+\u0006h%V.\ny0K-"));
    }

    public void deleteCertificate(byte[] byArray) throws RepositoryException {
        throw new RepositoryException(Pkcs12Repository.e("W4K \f~qQ'\u0017:8R8\u000f\u007f<Z&\u0017\u007f5\u0005h\ruqL!\r}=Zh\u0000\u007f#K!\u0005s2^<\u0006iqO:\u0006i4Q<"));
    }

    public PrivateKey getPrivateKey(byte[] byArray) throws RepositoryException {
        b b2 = new b(byArray);
        b b3 = new b(this.p.getLocalKeyID());
        if (!b2.equals(b3)) {
            return null;
        }
        try {
            PrivateKey privateKey = this.p.getPrivateKey();
            return privateKey;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void storePrivateKey(byte[] byArray, PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws RepositoryException {
        try {
            try {
                x509CertificateArray = Util.sortCertificateChain(x509CertificateArray);
            }
            catch (CTException cTException) {
                // empty catch block
            }
            byte[] byArray2 = new byte[]{67, 89, 66, 69, 82};
            this.p = new KeyBag(privateKey, new String(byArray), byArray2);
            this.q = new CertificateBag[x509CertificateArray.length];
            this.q[0] = new CertificateBag(x509CertificateArray[0], new String(byArray), byArray2);
            for (int i = 1; i < x509CertificateArray.length; ++i) {
                this.q[i] = new CertificateBag(x509CertificateArray[i]);
            }
            this.n = new PKCS12(this.p, this.q);
            this.n.encrypt(this.o.toCharArray());
            this.a();
        }
        catch (Exception exception) {
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void deletePrivateKey(byte[] byArray) throws RepositoryException {
        try {
            String string = new String(byArray);
            if (!string.equals(this.p.getLocalKeyID())) {
                return;
            }
            this.n = null;
            this.q = null;
            this.p = null;
            File file = new File(this.m);
            file.delete();
            file.createNewFile();
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public boolean isKeyEntry(byte[] byArray) throws RepositoryException {
        b b2 = new b(byArray);
        b b3 = new b(this.p.getLocalKeyID());
        return b2.equals(b3);
    }

    public void openNew(String string) throws RepositoryException {
        if (string == null || string.equals("")) {
            throw new RepositoryException(Pkcs12Repository.e("T$S$Cj0L;\u0014u#[h\ru%\u001f)\u000fv>H-\u00074"));
        }
        File file = new File(this.m);
        if (file.exists()) {
            throw new RepositoryException(String.valueOf(Pkcs12Repository.e("\\8S-Cu=M-\u0002~(\u001f-\u001bs\"KrC")).concat(String.valueOf(this.m)));
        }
        try {
            this.o = string;
            this.n = null;
            this.p = null;
            this.q = null;
            file.createNewFile();
        }
        catch (Exception exception) {
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void open() throws RepositoryException {
        throw new RepositoryException(Pkcs12Repository.e("W4K \f~qQ'\u0017:8R8\u000f\u007f<Z&\u0017\u007f5\u0005h\u0013{\"L?\fh5\u001f&\u0006\u007f5Z,"));
    }

    public boolean isOpened(boolean bl) {
        return this.n != null && this.q != null && this.p != null;
    }

    public void open(String string) throws RepositoryException {
        try {
            if (this.n == null) {
                File file = new File(this.m);
                if (!file.exists()) {
                    throw new RepositoryException(String.valueOf(Pkcs12Repository.e("\\8S-Ct>Kh\u0005u$Q,Y:")).concat(String.valueOf(this.m)));
                }
                if (file.length() > (long)0) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.n = new PKCS12((InputStream)fileInputStream);
                    fileInputStream.close();
                    this.n.decrypt(string.toCharArray());
                    this.q = this.n.getCertificateBags();
                    this.p = this.n.getKeyBag();
                }
            }
            this.o = string;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public void close() {
        this.n = null;
        this.q = null;
        this.p = null;
    }

    public void changePassword(String string, String string2) throws RepositoryException {
        try {
            this.n.decrypt(string.toCharArray());
            this.n.encrypt(string2.toCharArray());
            this.a();
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public AlgorithmID getSignatureAlgorithm() {
        return AlgorithmID.md5WithRSAEncryption;
    }

    public String toString() {
        int n = RepositoryException.c;
        String string = Pkcs12Repository.e("J:\\;R(\u0003Z8\fi8K'\u0011ck\u001f");
        try {
            block7: {
                X509Certificate[] x509CertificateArray;
                block8: {
                    block9: {
                        x509CertificateArray = this.getX509CertificateChain(this.p.getLocalKeyID());
                        if (n != 0) break block8;
                        if (x509CertificateArray != null) break block9;
                        string = String.valueOf(string).concat(String.valueOf(Pkcs12Repository.e(":yZ%\u0013n(\u0016h")));
                        if (n == 0) break block7;
                    }
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf(Pkcs12Repository.e("\u0010q^$\n{\"\u0005h")).concat(String.valueOf(new String(this.p.getLocalKeyID())))));
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    string = String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Pkcs12Repository.e("\u0010q\\-\u0011n8Y!\u0000{%ZrC")).concat(String.valueOf(x509CertificateArray[i].getSubjectDN()))).concat(String.valueOf(Pkcs12Repository.e(":\u0002qrC")))).concat(String.valueOf(x509CertificateArray[i].getSerialNumber()))));
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block7;
                }
                PrivateKey privateKey = this.getPrivateKey(this.p.getLocalKeyID());
                string = String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(Pkcs12Repository.e("\u0010[O:\nl0K-Cq4FrC")).concat(String.valueOf(privateKey.getAlgorithm()))).concat(String.valueOf("\n"))));
            }
            String string2 = string;
            return string2;
        }
        catch (Exception exception) {
            String string3 = "";
            return string3;
        }
    }

    private void a() throws Exception {
        File file = new File(this.m);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.n.writeTo((OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    void a(byte[] byArray, byte[] byArray2, X509Certificate[] x509CertificateArray) throws RepositoryException {
        b b2 = new b(byArray);
        b b3 = new b(this.p.getLocalKeyID());
        if (!b2.equals(b3)) {
            throw new RepositoryException(Pkcs12Repository.e("j4Q,\nt6\u001f)\u000fs0Lh\ru%\u001f.\fo?["));
        }
        PrivateKey privateKey = this.p.getPrivateKey();
        this.storePrivateKey(byArray2, privateKey, x509CertificateArray);
    }

    public KeyPair getKeyPair(byte[] byArray) throws RepositoryException {
        try {
            KeyPair keyPair;
            b b2 = new b(byArray);
            b b3 = new b(this.p.getLocalKeyID());
            if (!b2.equals(b3)) {
                KeyPair keyPair2 = null;
                return keyPair2;
            }
            PrivateKey privateKey = this.p.getPrivateKey();
            PublicKey publicKey = this.q[0].getCertificate().getPublicKey();
            KeyPair keyPair3 = keyPair = new KeyPair(publicKey, privateKey);
            return keyPair3;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    public PublicKey getPublicKey(byte[] byArray) throws RepositoryException {
        b b2 = new b(byArray);
        b b3 = new b(this.p.getLocalKeyID());
        if (!b2.equals(b3)) {
            return null;
        }
        try {
            X509Certificate x509Certificate = this.q[0].getCertificate();
            PublicKey publicKey = x509Certificate.getPublicKey();
            return publicKey;
        }
        catch (Exception exception) {
            this.a(exception);
            throw new RepositoryException(exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String e(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 26;
                        break;
                    }
                    case 1: {
                        n4 = 81;
                        break;
                    }
                    case 2: {
                        n4 = 63;
                        break;
                    }
                    case 3: {
                        n4 = 72;
                        break;
                    }
                    default: {
                        n4 = 99;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

